ORCA/M Asm65816 2.1.0

0001 6800              *********************************************************************************
0002 6800              *                                                                               *
0003 6800              *                               GLoader                                         *
0004 6800              *                                                                               *
0005 6800              *               Copyright Apple Computer, Inc. 1986-1993                        *
0006 6800              *                                                                               *
0007 6800              *                        All Rights Reserved                                    *
0008 6800              *                                                                               *
0009 6800              *********************************************************************************
0010 6800
0011 6800              *********************************************************************************
0012 6800                       SEG   'seg_gldr'
0013 6800              org_dummy_1 proc org gldr_obj_pstn
0014 6800                       endp 
0015 6800              *********************************************************************************
0016 6800
0017 6800              ;===============================================================================
0018 6800              ; setup
0019 6800              ;
0020 6800              ; Entry is in 16-bit native mode.
0021 6800              ; Exit is in 16-bit native mode.
0022 6800              ; Data bank is set to bank $00 on entry and exit.
0023 6800              ; Direct register is set to $0000 on entry and exit.
0024 6800              ; Stack is set to $01ff on entry.
0025 6800              ; Stack is set to GQuit's stack on exit.
0026 6800              ;
0027 6800              ; Standard entry point is at $6800.  A,X and Y are undefined.
0028 6800              ;
0029 6800              ; Entry point for custom boot is at $6803.  Register values should be -
0030 6800              ;   A - custom boot flags
0031 6800              ;   X - 0 (currently unused)
0032 6800              ;   Y - 0 (currently unused)
0033 6800              ;===============================================================================
0034 6800
0035 6800              setup    PROC 
0036 6800
0037 6800 A9 00 00              lda   #0                       ;initialize custom boot flags to 0
0038 6803              custom_entry                            ;entry point for custom boot
0039 6803 8D D8 7C              sta   |custom_boot             ;save custom boot flags
0040 6806
0041 6806                       longa off
0042 6806                       longi off
0043 6806 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0044 6808
0045 6808              ; make sure external cx rom is active to fix a bug in the 1.0gs rom
0046 6808              ; which caused the internal cx rom space to be left mapped in after a
0047 6808              ; boot failure (ie. boot disk not in drive) on smartport.
0048 6808
0049 6808              ;let's start with a known memory state.  it should be safe to do this.
0050 6808
0051 6808 A9 0C                 lda   #$0c                     ;enable rom/lcbnk 2/external $cn00 space
0052 680A 8D 68 C0              sta   statereg
0053 680D
0054 680D              ;get the boot slot # and save it for later (we have to do this before we put
0055 680D              ;up any text which will change the value in mslot)
0056 680D
0057 680D AF F8 07 00           lda   >mslot
0058 6811 8F D0 7C 00           sta   >save_mslot
0059 6815
0060 6815              ;put up the graphics version of the gs/os splash screen if no key was pressed
0061 6815
0062 6815 C2 30                 rep   #$30                     ;***** begin 16-bit mode *****
0063 6817 AD 0C 20              lda   |boot_obj_pstn+12        ;get aux type of START.GS.OS
0064 681A 20 09 73              jsr   splash_screen            ;to use as boot time value
0065 681D E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0066 681F
0067 681F              ;determine if graphics screen is up or if we should put up the text screen
0068 681F
0069 681F 9C F1 7C              stz   |text_flag+1             ;clear out hi byte of flag
0070 6822 AD 52 77              lda   |heart_active            ;get keypress flag from graphics code
0071 6825 8D F0 7C              sta   |text_flag               ;and save
0072 6828 F0 1F                 beq   skip_text                ;if 0 then graphics screen is up
0073 682A
0074 682A              ;a key was pressed so the text version of the splash screen should be put up
0075 682A              ;first check to see if internal slot 3 is enabled
0076 682A              ;if not, don't put up any text
0077 682A
0078 682A AF 17 C0 E0           lda   >e0rdc3rom               ;get slot 3 status
0079 682E 29 80                 and   #$80                     ;only want bit 7
0080 6830 49 80                 eor   #$80                     ;invert the bit
0081 6832 8D F0 7C              sta   |text_flag               ;and save
0082 6835 F0 12                 beq   skip_text                ;if 0 then internal slot 3 disabled
0083 6837
0084 6837              ;put up the text version of the gs/os splash screen
0085 6837
0086 6837 A9 A0                 lda   #$a0                     ;space character
0087 6839 20 00 C3              jsr   eighty_columns           ;clr scrn + enable 80 cols in basic
0088 683C
0089 683C A0 00                 ldy   #$00                     ;display product name
0090 683E B9 88 7D     gsos_name_loop lda   gs_os_credit,y
0091 6841 F0 06                 beq   gsos_name_done           ;done when a zero is encountered
0092 6843 20 ED FD              jsr   cout                     ;output the character to the screen
0093 6846 C8                    iny   
0094 6847 80 F5                 bra   gsos_name_loop           ;always loop waiting for a zero
0095 6849              gsos_name_done  
0096 6849
0097 6849              skip_text  
0098 6849
0099 6849              ; now let's set up the shadow register to ensure graphics shadowing
0100 6849              ; off and text page 1 shadowing on (preserve state of text page 2 shadowing)
0101 6849
0102 6849 AD 35 C0              lda   shadow
0103 684C 29 20                 and   #text_page_2_bit
0104 684E 09 1E                 ora   #p16_shadowmask
0105 6850 8D 35 C0              sta   shadow
0106 6853
0107 6853              ; disable interrupts so we can initialize tools and the memory manager.
0108 6853              ; this is done to allow pr# booting to work!!
0109 6853
0110 6853 08                    php                            ;save interrupt status
0111 6854 78                    sei                            ;turn off interrupts
0112 6855 0E D9 7C              asl   |custom_boot+1           ;skip this part of the boot process?
0113 6858 B0 16                 bcs   skipit1                  ;yes
0114 685A 22 00 00 FE           jsl   >initdismgr              ;initialize the tools and the memory mgr
0115 685E 20 1F FE              jsr   $FE1F                    ;call ROM ID routine
0116 6861 88                    dey                            ;ROM00 (better not be)
0117 6862 30 0C                 bmi   skipit1                  ;they're gonna crash eventually anyway
0118 6864 D0 06                 bne   @ROM03                   ;if non-zero, must be ROM03 or greater
0119 6866 22 06 1C FF           jsl   $FF1C06                  ;call ROM to initialize ATalk vectors
0120 686A 80 04                 bra   skipit1
0121 686C              @ROM03    
0122 686C 22 94 E5 FD           jsl   $FDE594                  ;call ROM to initialize ATalk vectors
0123 6870
0124 6870              skipit1   
0125 6870
0126 6870              ; disable AppleTalk and SCC
0127 6870
0128 6870 0E D9 7C              asl   |custom_boot+1           ;skip this part of the boot process?
0129 6873 B0 1A                 bcs   skipit2                  ;yes
0130 6875 9C 47 C0              stz   |$c047                   ;disable AppleTalk interrupts
0131 6878 9C 41 C0              stz   |$c041
0132 687B A9 09                 lda   #$09                     ;disable SCC
0133 687D 8D 39 C0              sta   |$c039
0134 6880 A9 C0                 lda   #$c0
0135 6882 8D 39 C0              sta   |$c039
0136 6885 A9 0B                 lda   #$0b                     ;enable oscillator
0137 6887 8D 39 C0              sta   |$c039
0138 688A A9 D2                 lda   #$d2
0139 688C 8D 39 C0              sta   |$c039
0140 688F              skipit2   
0141 688F
0142 688F              ; restore interrupt state
0143 688F
0144 688F 28                    plp   
0145 6890
0146 6890              ; if the graphics splash screen is up then re-enable the VBL interrupts
0147 6890              ; since initdismgr turned them off
0148 6890
0149 6890 20 0C 74              jsr   restart_heartbeat
0150 6893
0151 6893              ; now we must initialize the emulation stack save location at $010101 to
0152 6893              ; $fb, so when rom tool calls are made, the convention of setting the stack
0153 6893              ; pointer to the value present at $010101 when called from a program using
0154 6893              ; a native stack, can ensure not trashing the emulation mode stack
0155 6893
0156 6893 A9 FB                 lda   #$fb
0157 6895 8F 01 01 01           sta   >alemstkptr
0158 6899
0159 6899              ; write enable language card bank 0
0160 6899
0161 6899 AC 8B C0              ldy   lcbank1
0162 689C AC 8B C0              ldy   lcbank1
0163 689F
0164 689F              ; Now let's initialize some global flags
0165 689F
0166 689F A9 01                 lda   #$01                     ;indicate that this was a GS/OS boot
0167 68A1 8F BD 00 E1           sta   >os_boot
0168 68A5
0169 68A5 A9 FF                 lda   #$ff                     ;indicate that OS is not running yet
0170 68A7 8F BC 00 E1           sta   >os_kind
0171 68AB
0172 68AB 0E D9 7C              asl   |custom_boot+1           ;skip this part of the boot process?
0173 68AE B0 0A                 bcs   skipit3                  ;yes
0174 68B0 A9 6B                 lda   #$6b                     ;RTL opcode
0175 68B2 8F AC 00 E1           sta   >os_switch               ;initialize os_switch notification list.
0176 68B6 8F B4 00 E1           sta   >os_p8_switch            ;and the P8 switch notification list.
0177 68BA              skipit3   
0178 68BA
0179 68BA              ; begin 16-bit native mode
0180 68BA
0181 68BA                       longa on
0182 68BA                       longi on
0183 68BA C2 30                 rep   #$30                     ;***** begin 16-bit mode *****
0184 68BC
0185 68BC              ; indicate to GS/OS, FSTs, drivers, etc. that this is a "cold" start
0186 68BC
0187 68BC A9 00 00              lda   #$0000
0188 68BF 8F D0 01 E1           sta   >warm_cold_flag
0189 68C3
0190 68C3              ; set the stack to GQuit's stack
0191 68C3
0192 68C3 A9 FF BC              lda   #gquit_stack_top
0193 68C6 1B                    tcs   
0194 68C7
0195 68C7              ; Now relocate the GQuit code into the $e0 and $e1 language cards.
0196 68C7              ; Note - this code assumes the language card bank 0 is active on entry.
0197 68C7
0198 68C7              ; The B0 and E1 code goes to the 1st $d000 bank of the $e1 language card.
0199 68C7
0200 68C7 A2 00 82              ldx   #b0_obj_pstn             ;source adr
0201 68CA A0 00 D0              ldy   #lang_card_start         ;dest adr
0202 68CD A9 7C 09              lda   #e1_end-b0e1_obj_pstn-1  ;number of bytes to reloc - 1.
0203 68D0 54 E1 00              mvn   0, $E10000               ;move from bank 0 to bank $E1
0204 68D3
0205 68D3              ; The E0 code goes to the 1st $d000 bank of the $e0 language card.
0206 68D3
0207 68D3 A2 7D 8B              ldx   #b0_obj_pstn+(e1_end-b0e1_obj_pstn) ;source adr
0208 68D6 A0 00 D0              ldy   #lang_card_start         ;dest adr
0209 68D9 A9 F3 0F              lda   #e0_end-e0_obj_pstn-1    ;number of bytes to reloc - 1.
0210 68DC 54 E0 00              mvn   0, $E00000               ;move from bank 0 to bank $E0
0211 68DF
0212 68DF              ; set data bank register back to $00
0213 68DF
0214 68DF 4B                    phk                            ;the previous MVN instruction set the
0215 68E0 AB                    plb                            ;data bank register to $E0
0216 68E1
0217 68E1              ; copy boot slot # into GQuit's data area
0218 68E1
0219 68E1 AD D0 7C              lda   |save_mslot
0220 68E4 8F 91 D6 E1           sta   >e1_mslot
0221 68E8
0222 68E8              ; get a user id to use when allocating reserved memory segments for GS/OS and ProDOS 8
0223 68E8
0224 68E8 48                    pha                            ;space for result
0225 68E9 F4 00 32              pea   gquit_id_type            ;GLoader/GQuit use $32xx
0226 68EC A2 03 20 22           _getnewid 
0227 68F3 68                    pla                            ;get id
0228 68F4 8F 55 D6 E1           sta   >e1_os_mem_id            ;and save for use by GQuit
0229 68F8
0230 68F8              ; get a user id to use when allocating space for the Quit pathname
0231 68F8
0232 68F8 48                    pha                            ;space for result
0233 68F9 F4 00 32              pea   gquit_id_type            ;GLoader/GQuit use $32xx
0234 68FC A2 03 20 22           _getnewid 
0235 6903 68                    pla                            ;get id
0236 6904 8F 69 D6 E1           sta   >e1_path_id              ;and save for use by GQuit
0237 6908
0238 6908              ; get a user id to use when allocating space to save GS/OS while ProDOS 8 is running
0239 6908
0240 6908 48                    pha                            ;space for result
0241 6909 F4 00 32              pea   gquit_id_type            ;GLoader/GQuit use $32xx
0242 690C A2 03 20 22           _getnewid 
0243 6913 68                    pla                            ;get id
0244 6914 8F 57 D6 E1           sta   >e1_storage_id           ;and save for use by GQuit
0245 6918
0246 6918              ; get a user id to use when allocating space to save a copy of P8
0247 6918
0248 6918 48                    pha                            ;space for result
0249 6919 F4 00 32              pea   gquit_id_type            ;GLoader/GQuit use $32xx
0250 691C A2 03 20 22           _getnewid 
0251 6923 68                    pla                            ;get id
0252 6924 8F 59 D6 E1           sta   >e1_p8copy_id            ;and save for use by GQuit
0253 6928
0254 6928              ; Allocate the bank 0 memory currently being used by GLoader
0255 6928
0256 6928 22 3A 70 00           jsl   alloc_boot_mem
0257 692C B0 06                 bcs   @oops                    ;huh???
0258 692E
0259 692E              ; Allocate GS/OS's reserved memory segments.
0260 692E
0261 692E 22 2F DE E0           jsl   alloc_gsos_mem
0262 6932 90 06                 bcc   got_gsos_mem
0263 6934              @oops     
0264 6934 A2 7F 7E              ldx   #alloc_err               ;address of error msg
0265 6937 4C CB 6C              jmp   system_death             ;doesn't return
0266 693A              got_gsos_mem  
0267 693A
0268 693A              ; Now ask for 64k of memory space outside of banks $00/$01 which will be used to
0269 693A              ; load GS/OS and related files.
0270 693A
0271 693A 22 60 70 00           jsl   alloc_work_mem
0272 693E 90 06                 bcc   got_work_mem             ;if c=1, error in A
0273 6940 A2 4E 7E              ldx   #mem_size_err            ;address of error msg
0274 6943 4C CB 6C              jmp   system_death             ;doesn't return
0275 6946              got_work_mem  
0276 6946
0277 6946              ; fall through into 'main'
0278 6946
0279 6946                       eject 
0280 6946              ;===============================================================================
0281 6946              ; main
0282 6946              ;
0283 6946              ; Entry is in 16-bit native mode.
0284 6946              ; Exit is in 16-bit native mode.
0285 6946              ; Data bank is set to bank $00 on entry and exit.
0286 6946              ; Direct register is set to $0000 on entry and exit.
0287 6946              ; Stack is set to GQuit's stack on entry and exit.
0288 6946              ;===============================================================================
0289 6946
0290 6946              main      
0291 6946                       DataChk Off
0292 6946
0293 6946                       longa on
0294 6946                       longi on
0295 6946
0296 6946              ; check for a depressed shift key, which means that the user does not wish
0297 6946              ; to have INIT's and DA's loaded
0298 6946
0299 6946 A9 00 00              lda   #0                       ; assume we're gonna load extensions
0300 6949 8F B8 00 E1           sta   >os_public_flags
0301 694D AF 25 C0 E1           lda   >$E1C025                 ; get keyboard modifier flags
0302 6951 4A                    lsr   a                        ; shift key down?
0303 6952 90 0A                 bcc   @load_extensions         ; no, go ahead and load the extensions
0304 6954 20 6A 76              jsr   draw_ext_off             ; draw the skip message
0305 6957 A9 00 80              lda   #$8000
0306 695A 8F B8 00 E1           sta   >os_public_flags         ; set the flag for the rest of the system
0307 695E              @load_extensions  
0308 695E
0309 695E              ; Get the name of the boot volume
0310 695E
0311 695E F4 E1 00              pea   e1_volname>>16           ;pointer to space for volume name
0312 6961 F4 F7 D6              pea   e1_volname
0313 6964 A2 06 00              ldx   #6                       ;offset to GetBootName routine
0314 6967 FC 00 20              jsr   (boot_obj_pstn,x)        ;get the volume name
0315 696A 90 06                 bcc   got_volname              ;if c=1, error in A
0316 696C A2 AA 7E              ldx   #volname_err             ;address of error msg
0317 696F 4C CB 6C              jmp   system_death             ;doesn't return
0318 6972              got_volname  
0319 6972
0320 6972              ; Get the name of the start fst
0321 6972
0322 6972 F4 00 00              pea   startfst_name>>16        ;pointer to space for fst name
0323 6975 F4 66 7D              pea   startfst_name
0324 6978 A2 08 00              ldx   #8                       ;offset to GetFstName routine
0325 697B FC 00 20              jsr   (boot_obj_pstn,x)        ;get the start fst name
0326 697E
0327 697E              ; Create the pathname of the start fst
0328 697E
0329 697E F4 01 00              pea   1                        ;indicate class 1 strings
0330 6981 F4 00 00              pea   startfst_path>>16        ;Push ptr to string1
0331 6984 F4 9B 7F              pea   startfst_path
0332 6987 F4 00 00              pea   startfst_name>>16        ;Push ptr to string2
0333 698A F4 66 7D              pea   startfst_name
0334 698D F4 00 00              pea   startfst_path>>16        ;Push ptr to resultant string
0335 6990 F4 9B 7F              pea   startfst_path
0336 6993 22 AB D2 E1           jsl   concat
0337 6997
0338 6997              ; Now look for */SYSTEM/GS.OS and read it into memory
0339 6997
0340 6997 A2 69 7F              ldx   #gsos_path               ;address of partial pathname
0341 699A A0 00 00              ldy   #gsos_path>>16
0342 699D 20 9E 70              jsr   read_the_file            ;read in the file
0343 69A0 90 06                 bcc   read_ok                  ;if c=1, error in A
0344 69A2 A2 D0 7E              ldx   #gsos_err                ;address of error msg
0345 69A5 4C CB 6C              jmp   system_death             ;doesn't return
0346 69A8              read_ok   
0347 69A8 20 33 72              jsr   relocate_segs            ;relocate the code segments
0348 69AB
0349 69AB              ; Install the system loader
0350 69AB
0351 69AB 22 6E 7C 00           jsl   loader_install
0352 69AF 90 06                 bcc   loader_ok                ;if c=1, error in A
0353 69B1 A2 F2 7E              ldx   #loader_err              ;address of error msg
0354 69B4 4C CB 6C              jmp   system_death             ;doesn't return
0355 69B7              loader_ok  
0356 69B7
0357 69B7              ; Load */SYSTEM/ERROR.MSG
0358 69B7
0359 69B7 A2 77 7F              ldx   #errmsg_path             ;address of partial pathname
0360 69BA A0 00 00              ldy   #errmsg_path>>16
0361 69BD 20 9E 70              jsr   read_the_file            ;read in the file
0362 69C0 B0 05                 bcs   msg_file_error
0363 69C2 20 EF 6C              jsr   load_err_msgs            ;call the loader
0364 69C5 90 06                 bcc   msgfile_ok
0365 69C7              msg_file_error  
0366 69C7 A2 1A 7F              ldx   #msgfile_err             ;address of error msg
0367 69CA 4C CB 6C              jmp   system_death             ;doesn't return
0368 69CD              msgfile_ok  
0369 69CD
0370 69CD              ; Make sure our error messages are not suppressed
0371 69CD
0372 69CD AF F6 B9 00           lda   >sys_prefs               ;get preferences flag
0373 69D1 29 FF DF              and   #$DFFF                   ;clear bit 13
0374 69D4 8F F6 B9 00           sta   >sys_prefs
0375 69D8
0376 69D8              ; Load and startup */SYSTEM/GS.OS.DEV
0377 69D8
0378 69D8 A2 89 7F              ldx   #gsosdev_path            ;address of partial pathname
0379 69DB A0 00 00              ldy   #gsosdev_path>>16
0380 69DE 20 9E 70              jsr   read_the_file            ;read in the file
0381 69E1 B0 05                 bcs   gsosdev_error
0382 69E3 20 35 6D              jsr   load_gsosdev             ;call the loader
0383 69E6 90 07                 bcc   gsosdev_ok
0384 69E8
0385 69E8              ; We got an error reading in the GS.OS.DEV file or from the loader
0386 69E8
0387 69E8              gsosdev_error  
0388 69E8 A2 2A 00              ldx   #gsosdev_err             ;message #
0389 69EB 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0390 69EF
0391 69EF              ; The GS.OS.DEV file was read in without an error
0392 69EF
0393 69EF              gsosdev_ok  
0394 69EF
0395 69EF              ; Read in the start FST file
0396 69EF
0397 69EF A2 9B 7F              ldx   #startfst_path           ;address of partial pathname
0398 69F2 A0 00 00              ldy   #startfst_path>>16
0399 69F5 20 9E 70              jsr   read_the_file            ;read in the file
0400 69F8 B0 12                 bcs   start_fst_error
0401 69FA AD FA 7C              lda   |filetype                ;get the start FST's filetype
0402 69FD C9 BD 00              cmp   #fst_ftype               ;is it an FST file?
0403 6A00 D0 11                 bne   fst_type_error           ;no - so report an error
0404 6A02 AD FC 7C              lda   |auxtype                 ;get the start FST's auxtype
0405 6A05 30 0C                 bmi   fst_type_error           ;it's disabled so report an error
0406 6A07 20 57 6D              jsr   load_start_fst           ;call the loader
0407 6A0A 90 0E                 bcc   start_fst_ok
0408 6A0C
0409 6A0C              ; We got an error reading in the start FST or from the loader
0410 6A0C
0411 6A0C              start_fst_error  
0412 6A0C A2 04 00              ldx   #start_fst_err           ;message #
0413 6A0F 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0414 6A13
0415 6A13              ; The start FST is disabled or has the wrong file type
0416 6A13
0417 6A13              fst_type_error  
0418 6A13 A2 22 00              ldx   #fst_type_err            ;message #
0419 6A16 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0420 6A1A
0421 6A1A              ; The start FST file was read in without an error
0422 6A1A
0423 6A1A              start_fst_ok  
0424 6A1A
0425 6A1A              ; Read in the custom boot driver file if requested
0426 6A1A
0427 6A1A 0E D8 7C              asl   |custom_boot             ;load a custom boot driver?
0428 6A1D 90 2E                 bcc   skipit4                  ;no
0429 6A1F
0430 6A1F A2 C9 7F              ldx   #driver_path             ;address of partial pathname
0431 6A22 A0 00 00              ldy   #driver_path>>16
0432 6A25 20 9E 70              jsr   read_the_file            ;read in the file
0433 6A28 B0 15                 bcs   boot_drvr_error
0434 6A2A AD FA 7C              lda   |filetype                ;get the boot driver's filetype
0435 6A2D C9 BB 00              cmp   #drvr_ftype              ;is it a driver file?
0436 6A30 D0 14                 bne   drvr_type_error          ;no - so report an error
0437 6A32 AD FC 7C              lda   |auxtype                 ;get the boot driver's auxtype
0438 6A35 C9 81 01              cmp   #drvr_atype              ;is it the correct type?
0439 6A38 D0 0C                 bne   drvr_type_error          ;no - so report an error
0440 6A3A 20 70 6D              jsr   load_boot_drvr           ;call the loader
0441 6A3D 90 0E                 bcc   boot_drvr_ok
0442 6A3F
0443 6A3F              ; We got an error reading in the boot driver or from the loader
0444 6A3F
0445 6A3F              boot_drvr_error  
0446 6A3F A2 24 00              ldx   #boot_drvr_err           ;message #
0447 6A42 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0448 6A46
0449 6A46              ; The boot driver has the wrong file type or the wrong aux type
0450 6A46
0451 6A46              drvr_type_error  
0452 6A46 A2 25 00              ldx   #drvr_type_err           ;message #
0453 6A49 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0454 6A4D
0455 6A4D              ; The boot driver file was read in without an error
0456 6A4D
0457 6A4D              boot_drvr_ok  
0458 6A4D
0459 6A4D              ; Custom boot driver is not requested
0460 6A4D
0461 6A4D              skipit4   
0462 6A4D
0463 6A4D              ; Free up the 64K buffer used to load in GS/OS and related files
0464 6A4D
0465 6A4D AD E8 7C              lda   |buf_hndl+2              ;handle to mem buffer
0466 6A50 48                    pha   
0467 6A51 AD E6 7C              lda   |buf_hndl
0468 6A54 48                    pha   
0469 6A55 A2 02 10 22           _disposehandle 
0470 6A5C
0471 6A5C              ; Now let's initialize the AppleTalk priority vector
0472 6A5C
0473 6A5C 0E D8 7C              asl   |custom_boot             ;skip this part of the boot process?
0474 6A5F B0 0E                 bcs   skipit5                  ;yes
0475 6A61 A9 6B 00              lda   #$006b                   ; an 'RTL' followed by 3 nulls
0476 6A64 8F 3A 10 E1           sta   >a_t_vect
0477 6A68 A9 00 00              lda   #$0000
0478 6A6B 8F 3C 10 E1           sta   >a_t_vect+2
0479 6A6F              skipit5   
0480 6A6F
0481 6A6F              ; Do GS/OS initialization sequence here...
0482 6A6F
0483 6A6F A2 02 1F 22           _CompactMem                    ;{gab - 04/03/90}
0484 6A76
0485 6A76              ; set direct reg to GS/OS direct page for calls to SCM and device dispatcher
0486 6A76
0487 6A76 0B                    phd                            ;save direct register
0488 6A77 F4 00 BD              pea   direct_base              ;setup GS/OS direct page
0489 6A7A 2B                    pld   
0490 6A7B
0491 6A7B              ; initialize SCM
0492 6A7B
0493 6A7B 22 08 D4 00           jsl   >init_scm
0494 6A7F B0 3B                 bcs   init_error
0495 6A81
0496 6A81              ; add in the start FST
0497 6A81
0498 6A81 AE 00 7D              ldx   |fst_address             ;get load address of start.fst
0499 6A84 AC 02 7D              ldy   |fst_address+2           ;x=low word  --  y=high word
0500 6A87 22 DF DB E1           jsl   >add_fst                 ;notify SCM
0501 6A8B B0 2F                 bcs   init_error
0502 6A8D
0503 6A8D              ; initialize the device dispatcher
0504 6A8D
0505 6A8D A2 02 1F 22           _CompactMem                    ;{gab - 04/03/90}
0506 6A94
0507 6A94 64 00                 stz   <drvr_dev_num            ;device number = dispatcher
0508 6A96 64 02                 stz   <drvr_call_num           ;call number = boot init
0509 6A98 AF 91 D6 E1           lda   >e1_mslot                ;get boot slot #
0510 6A9C 29 07 00              and   #$0007                   ;mask off bits which must be 0
0511 6A9F 85 04                 sta   <boot_slot               ;boot slot #
0512 6AA1 AF EF D6 E1           lda   >e1_drvr_address         ;load address of custom boot driver if
0513 6AA5 85 20                 sta   <drvr_dib_ptr            ;one was requested, else nil
0514 6AA7 AF F1 D6 E1           lda   >e1_drvr_address+2
0515 6AAB 85 22                 sta   <drvr_dib_ptr+2
0516 6AAD AF 75 D6 E1           lda   >e1_drvr_id              ;user ID of custom boot driver if one
0517 6AB1 85 6A                 sta   <boot_user_id            ;was requested, else 0
0518 6AB3 22 00 FC 01           jsl   >dev_dispatcher          ;initialize the device dispatcher
0519 6AB7 B0 03                 bcs   init_error
0520 6AB9
0521 6AB9              ; restore direct register
0522 6AB9
0523 6AB9 2B                    pld   
0524 6ABA 80 07                 bra   init_ok
0525 6ABC
0526 6ABC              ; got an error during GS/OS initialization
0527 6ABC
0528 6ABC              init_error  
0529 6ABC A2 05 00              ldx   #init_gsos_err           ;message #
0530 6ABF 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0531 6AC3
0532 6AC3              ; GS/OS was initialized without error
0533 6AC3
0534 6AC3              init_ok   
0535 6AC3
0536 6AC3              ; Indicate that GS/OS is now up and running so that the report_fatal routine can
0537 6AC3              ; attempt to shutdown GS/OS if a fatal error occurs.
0538 6AC3
0539 6AC3 A9 01 00              lda   #1
0540 6AC6 8F E9 D6 E1           sta   >e1_gsos_ok
0541 6ACA
0542 6ACA              ; Now install the rest of the FSTs in the */SYSTEM/FSTS subdirectory
0543 6ACA
0544 6ACA 20 8F 6D              jsr   load_fsts
0545 6ACD 90 12                 bcc   fsts_ok
0546 6ACF AC FE 7C              ldy   |got_filename            ;do we have a filename for the error msg?
0547 6AD2 D0 07                 bne   fst_fn_err               ;yes - so put up a special msg
0548 6AD4 A2 06 00              ldx   #load_fst_err            ;message #
0549 6AD7 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0550 6ADB A2 39 00     fst_fn_err ldx   #load_fst_err2         ;message #
0551 6ADE 4C D7 6C              jmp   fatal_fn_err             ;fatal error - no return
0552 6AE1              fsts_ok   
0553 6AE1
0554 6AE1              ; This is code to pause the load sequence if a key has been pressed.
0555 6AE1
0556 6AE1 AD F0 7C              lda   |text_flag               ;should the text message be put up?
0557 6AE4 F0 48                 beq   skip_msg                 ;no
0558 6AE6
0559 6AE6 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0560 6AE8                       longi off
0561 6AE8                       longa off
0562 6AE8
0563 6AE8 AD 00 C0              lda   kbd                      ;'-' if key is pressed
0564 6AEB 10 3F                 bpl   nokeythistime2           ;'+' then no key pressed this time
0565 6AED 8D 10 C0              sta   kbdstrb                  ;clear keypress and wait for another
0566 6AF0
0567 6AF0 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0568 6AF2                       longa on
0569 6AF2                       longi on
0570 6AF2
0571 6AF2 A0 00 00              ldy   #$00                     ;display 'press any key to continue'
0572 6AF5              pressanykeylp  
0573 6AF5 B9 27 7E              lda   pressanykey,y            ;get character
0574 6AF8 29 FF 00              and   #$00ff
0575 6AFB              *** The next line was branching to pressanykeydone in 16-bit mode, 18-Feb-93 DAL
0576 6AFB F0 0B                 beq   @1                       ;'0' is terminator
0577 6AFD 5A                    phy                            ;save Y
0578 6AFE A2 ED FD              ldx   #cout
0579 6B01 20 F5 72              jsr   call_fw
0580 6B04 7A                    ply                            ;restore Y
0581 6B05 C8                    iny                            ;next character
0582 6B06 80 ED                 bra   pressanykeylp
0583 6B08
0584 6B08 E2 30        @1       sep   #$30                     ;***** begin 8-bit mode *****
0585 6B0A                       longi off
0586 6B0A                       longa off
0587 6B0A
0588 6B0A              pressanykeydone  
0589 6B0A AD 00 C0              lda   kbd                      ;to continue with the boot
0590 6B0D 10 FB                 bpl   pressanykeydone          ;loop til key pressed
0591 6B0F 8D 10 C0              sta   kbdstrb                  ;clear keypress and continue with boot
0592 6B12
0593 6B12              *** added 9-Mar-93 DAL -- remove the "press any key" message
0594 6B12 A9 00                 lda   #0
0595 6B14 85 24                 sta   $24                      ;HTAB to 0
0596 6B16 8D 7B 05              sta   $57b                     ;80-col cursor-horizontal
0597 6B19
0598 6B19 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0599 6B1B                       longa on
0600 6B1B                       longi on
0601 6B1B
0602 6B1B A9 50 00              lda   #80
0603 6B1E 48           @blanks  pha   
0604 6B1F A9 A0 00              lda   #$A0                     ;space
0605 6B22 A2 ED FD              ldx   #cout
0606 6B25 20 F5 72              jsr   call_fw
0607 6B28 68                    pla   
0608 6B29 3A                    dec   a
0609 6B2A D0 F2                 bne   @blanks
0610 6B2C              *** end 9-Mar-93
0611 6B2C
0612 6B2C              nokeythistime2  
0613 6B2C C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0614 6B2E                       longa on
0615 6B2E                       longi on
0616 6B2E
0617 6B2E              skip_msg  
0618 6B2E
0619 6B2E              ; Now set prefix 0 to the boot volume name
0620 6B2E
0621 6B2E 22 A8 00 E1           _setprefix1 setpfx0_parms1 
0622 6B38 90 07                 bcc   pfx0_ok
0623 6B3A A2 07 00              ldx   #prefix_0_err            ;message #
0624 6B3D 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0625 6B41              pfx0_ok   
0626 6B41
0627 6B41              ; Set the library prefix to '*/SYSTEM/LIBS'
0628 6B41
0629 6B41 22 A8 00 E1           _setprefix1 e1_setpfx2_parms1 
0630 6B4B 90 07                 bcc   pfx2_ok
0631 6B4D A2 08 00              ldx   #prefix_2_err            ;message #
0632 6B50 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0633 6B54              pfx2_ok   
0634 6B54
0635 6B54              ; Set OS_Kind to $01 to indicate that GS/OS is running
0636 6B54
0637 6B54                       longa off
0638 6B54                       longi off
0639 6B54 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0640 6B56
0641 6B56 A9 01                 lda   #$01
0642 6B58 8F BC 00 E1           sta   >OS_Kind
0643 6B5C
0644 6B5C C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0645 6B5E                       longa on
0646 6B5E                       longi on
0647 6B5E
0648 6B5E              ; Now look for '*/SYSTEM/START'
0649 6B5E
0650 6B5E A9 6B 80              lda   #startpath               ;set up parameters for call
0651 6B61 8F D3 D5 E1           sta   >e1_gfi_ptr
0652 6B65 A9 00 00              lda   #startpath>>16
0653 6B68 8F D5 D5 E1           sta   >e1_gfi_ptr+2
0654 6B6C
0655 6B6C 22 A8 00 E1           _getfileinfo1 e1_gfi_parms1 
0656 6B76 B0 09                 bcs   no_start
0657 6B78
0658 6B78 AF D9 D5 E1           lda   >e1_gfi_ftype            ;check filetype of START file
0659 6B7C C9 B3 00              cmp   #s16_ftype
0660 6B7F F0 18                 beq   found_start
0661 6B81              no_start  
0662 6B81
0663 6B81              ; No START file in SYSTEM directory was found, so look for 1st
0664 6B81              ; '.system' or '.sys16' file in volume directory
0665 6B81
0666 6B81 20 34 71              jsr   find_sys_file
0667 6B84 90 13                 bcc   found_sysfile
0668 6B86 C9 61 00              cmp   #end_of_dir              ; end of directory error?
0669 6B89 F0 07                 beq   no_sysfile               ; yes - so there is no sys file
0670 6B8B A2 09 00              ldx   #sys_search_err          ;message #
0671 6B8E 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0672 6B92
0673 6B92              ; No .sys16 or .system file was found so report an error
0674 6B92
0675 6B92              no_sysfile  
0676 6B92 A2 0A 00              ldx   #no_sys_file_err         ;message #
0677 6B95 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0678 6B99
0679 6B99              ; A .sys16 or .system file entry was found
0680 6B99
0681 6B99              found_sysfile  
0682 6B99
0683 6B99              ; A START file was found
0684 6B99
0685 6B99              found_start  
0686 6B99
0687 6B99              ; Now load and execute '*/SYSTEM/SYSTEM.SETUP/TOOL.SETUP'
0688 6B99
0689 6B99 A2 02 1F 22           _CompactMem                    ;{gab - 04/03/90}
0690 6BA0
0691 6BA0 A9 10 80              lda   #toolsetup_path          ;setup parameters for call
0692 6BA3 8F D3 D5 E1           sta   >e1_gfi_ptr
0693 6BA7 A9 00 00              lda   #toolsetup_path>>16
0694 6BAA 8F D5 D5 E1           sta   >e1_gfi_ptr+2
0695 6BAE
0696 6BAE 22 A8 00 E1           _getfileinfo1 e1_gfi_parms1    ; does the file exist?
0697 6BB8 B0 14                 bcs   ts_file_error            ; no - so report an error
0698 6BBA
0699 6BBA AF D9 D5 E1           lda   >e1_gfi_ftype            ; get filetype of TOOL.SETUP
0700 6BBE C9 B6 00              cmp   #perm_ftype              ; is it the correct filetype?
0701 6BC1 D0 12                 bne   bad_ts_type              ; no - so report an error
0702 6BC3
0703 6BC3 A2 10 80              ldx   #toolsetup_path          ; X gets lo word of pathname address
0704 6BC6 A0 00 00              ldy   #toolsetup_path>>16      ; Y gets hi word of pathname adrs
0705 6BC9 20 1F 6F              jsr   load_setup               ; Go load and run the file
0706 6BCC 90 0E                 bcc   tools_ok                 ; Branch if successful
0707 6BCE
0708 6BCE              ; The TOOL.SETUP file doesn't exist or we got an error trying to execute it
0709 6BCE
0710 6BCE              ts_file_error  
0711 6BCE A2 0B 00              ldx   #tool_setup_err          ;message #
0712 6BD1 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0713 6BD5
0714 6BD5              ; The TOOL.SETUP file has the wrong file type
0715 6BD5
0716 6BD5              bad_ts_type  
0717 6BD5 A2 11 00              ldx   #ts_type_err             ;message #
0718 6BD8 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0719 6BDC
0720 6BDC              ; TOOL.SETUP was loaded and executed without error
0721 6BDC
0722 6BDC              tools_ok  
0723 6BDC F4 00 A0              pea   $A000                    ;purge any leftover Tool.Setup stuff
0724 6BDF A2 02 13 22           _PurgeAll 
0725 6BE6
0726 6BE6              ; Now load and execute '*/SYSTEM/SYSTEM.SETUP/RESOURCE.MGR'
0727 6BE6
0728 6BE6 A9 32 80              lda   #resmgr_path             ;setup parameters for call
0729 6BE9 8F D3 D5 E1           sta   >e1_gfi_ptr
0730 6BED A9 00 00              lda   #resmgr_path>>16
0731 6BF0 8F D5 D5 E1           sta   >e1_gfi_ptr+2
0732 6BF4
0733 6BF4 22 A8 00 E1           _getfileinfo1 e1_gfi_parms1    ; does the file exist?
0734 6BFE B0 14                 bcs   rm_file_error            ; no - so report an error
0735 6C00
0736 6C00 AF D9 D5 E1           lda   >e1_gfi_ftype            ; get filetype of RESOURCE.MGR
0737 6C04 C9 B6 00              cmp   #perm_ftype              ; is it the correct filetype?
0738 6C07 D0 12                 bne   bad_rm_type              ; no - so report an error
0739 6C09
0740 6C09 A2 32 80              ldx   #resmgr_path             ; X gets lo word of pathname address
0741 6C0C A0 00 00              ldy   #resmgr_path>>16         ; Y gets hi word of pathname adrs
0742 6C0F 20 1F 6F              jsr   load_setup               ; Go load and run the file
0743 6C12 90 0E                 bcc   resmgr_ok                ; Branch if successful
0744 6C14
0745 6C14              ; The RESOURCE.MGR file doesn't exist or we got an error trying to execute it
0746 6C14
0747 6C14              rm_file_error  
0748 6C14 A2 26 00              ldx   #res_mgr_err             ;message #
0749 6C17 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0750 6C1B
0751 6C1B              ; The RESOURCE.MGR file has the wrong file type
0752 6C1B
0753 6C1B              bad_rm_type  
0754 6C1B A2 27 00              ldx   #rm_type_err             ;message #
0755 6C1E 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0756 6C22
0757 6C22              ; RESOURCE.MGR was loaded and executed without error
0758 6C22
0759 6C22              resmgr_ok  
0760 6C22
0761 6C22              ; Load and execute any other setup files in */SYSTEM/SYSTEM.SETUP
0762 6C22
0763 6C22 AF B8 00 E1           lda   >os_public_flags         ; load INIT's and DA's?
0764 6C26 10 06                 bpl   @load_extensions         ; yes...
0765 6C28 22 3A 10 E1           jsl   >a_t_vect                ; init AppleTalk priority queue
0766 6C2C 80 41                 bra   nodaerr                  ; then skip loading of INITs and DAs
0767 6C2E
0768 6C2E              @load_extensions  
0769 6C2E 22 D9 73 00           jsl   stop_scrn_chk            ; disable screen monitoring
0770 6C32 20 73 6E              jsr   load_setup_files
0771 6C35 90 12                 bcc   nosetuperr
0772 6C37 AC FE 7C              ldy   |got_filename            ;do we have a filename for the error msg?
0773 6C3A D0 07                 bne   setup_fn_err             ;yes - so put up a special msg
0774 6C3C A2 0C 00              ldx   #load_setup_err          ;message #
0775 6C3F 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0776 6C43 A2 3A 00     setup_fn_err ldx   #load_setup_err2     ;message #
0777 6C46 4C D7 6C              jmp   fatal_fn_err             ;fatal error - no return
0778 6C49              nosetuperr  
0779 6C49 22 A8 73 00           jsl   start_scrn_chk           ; enable screen monitoring
0780 6C4D
0781 6C4D              ; Now initialize the AppleTalk priority queue
0782 6C4D
0783 6C4D 22 3A 10 E1           jsl   >a_t_vect
0784 6C51
0785 6C51              ; Install all Desk Accessories in the /*/SYSTEM/DESK.ACCS subdirectory
0786 6C51
0787 6C51 A2 02 1F 22           _CompactMem                    ;{gab - 04/03/90}
0788 6C58
0789 6C58 20 69 6F              jsr   load_da_files
0790 6C5B 90 12                 bcc   nodaerr
0791 6C5D AC FE 7C              ldy   |got_filename            ;do we have a filename for the error msg?
0792 6C60 D0 07                 bne   da_fn_err                ;yes - so put up a special msg
0793 6C62 A2 0D 00              ldx   #load_da_err             ;message #
0794 6C65 5C BF DF E0           jmp   >gsos_fatal_err2         ;fatal error - no return
0795 6C69 A2 3B 00     da_fn_err ldx   #load_da_err2           ;message #
0796 6C6C 4C D7 6C              jmp   fatal_fn_err             ;fatal error - no return
0797 6C6F              nodaerr   
0798 6C6F
0799 6C6F              ; Create class 0 and class 1 versions of the start program pathname
0800 6C6F
0801 6C6F 22 8B D3 E1           jsl   make_start_paths
0802 6C73
0803 6C73              ; Enable screen monitoring
0804 6C73
0805 6C73 22 EE 73 00           jsl   start_app_chk
0806 6C77
0807 6C77              ; If the start file is a ProDOS 8 file (filetype $FF) then fill the thermometer
0808 6C77              ; up to the end, stop the splash screen, write out the new auxtype and switch
0809 6C77              ; into text mode before P8 gets loaded.
0810 6C77
0811 6C77 AD DC 7C              lda   |save_filetype           ;get the filetype of the start file
0812 6C7A C9 FF 00              cmp   #sys_ftype               ;is it a ProDOS 8 file?
0813 6C7D D0 04                 bne   not_p8                   ;no
0814 6C7F 22 CC 73 00           jsl   stop_splash              ;yes - so shutdown the splash screen
0815 6C83              not_p8    
0816 6C83
0817 6C83              ; Resize the segment allocated for the ERROR.MSG file in order to get rid of the
0818 6C83              ; temporary error messages which are only needed during initial boot.
0819 6C83
0820 6C83 F4 00 00              pea   0                        ;hi word of new size
0821 6C86 AD DE 7C              lda   |perm_msg_size
0822 6C89 48                    pha                            ;lo word of new size
0823 6C8A 48                    pha                            ;space for handle result
0824 6C8B 48                    pha   
0825 6C8C AF F5 D6 E1           lda   >e1_msg_address+2
0826 6C90 48                    pha                            ;starting address of the segment
0827 6C91 AF F3 D6 E1           lda   >e1_msg_address
0828 6C95 48                    pha   
0829 6C96 A2 02 1A 22           _FindHandle                    ;get handle to the segment
0830 6C9D A2 02 19 22           _SetHandleSize                 ;resize the segment
0831 6CA4
0832 6CA4              ; Indicate to GS/OS, FSTs, drivers, etc. that any future startup and
0833 6CA4              ; shutdown calls are "warm" (ie - we are switching between operating systems)
0834 6CA4
0835 6CA4 A9 01 00              lda   #$0001
0836 6CA7 8F D0 01 E1           sta   >warm_cold_flag
0837 6CAB
0838 6CAB A2 02 1F 22           _CompactMem                    ;{gab - 04/03/90}
0839 6CB2
0840 6CB2              ; Free up the memory used by GLoader
0841 6CB2
0842 6CB2 AD E4 7C              lda   |boot_hndl+2             ;handle to bank 0 memory
0843 6CB5 48                    pha   
0844 6CB6 AD E2 7C              lda   |boot_hndl
0845 6CB9 48                    pha   
0846 6CBA A2 02 10 22           _disposehandle 
0847 6CC1
0848 6CC1              ; Now do a class 1 Quit call to execute the start program
0849 6CC1
0850 6CC1 22 A8 00 E1           _quit1 quit_parms1
0851 6CCB
0852 6CCB                       DataChk off
0853 6CCB                       ENDP 
0854 6CCB
0855 6CCB
0856 6CCB
0857 6CCB                       eject 
0858 6CCB              ;===============================================================================
0859 6CCB              ; system_death
0860 6CCB              ;
0861 6CCB              ; Entry is in 16-bit native mode.
0862 6CCB              ;
0863 6CCB              ; Inputs:       A - error # to display
0864 6CCB              ;               X - address of error message  (must be in bank $00)
0865 6CCB              ;
0866 6CCB              ; Outputs:      none
0867 6CCB              ;
0868 6CCB              ; Notes:        This routine does not return.
0869 6CCB              ;
0870 6CCB              ; Displays an error message and error number using the SysFailMgr tool call.
0871 6CCB              ;===============================================================================
0872 6CCB
0873 6CCB              system_death PROC 
0874 6CCB                       longa on
0875 6CCB                       longi on
0876 6CCB
0877 6CCB 48                    pha                            ; Push error number on stack.
0878 6CCC F4 00 00              pea   $0000                    ; Assumes bank $00 for location of msg!
0879 6CCF DA                    phx                            ; Push address of error message.
0880 6CD0 A2 03 15 22           _sysfailmgr                    ; doesn't return
0881 6CD7                       ENDP 
0882 6CD7
0883 6CD7
0884 6CD7
0885 6CD7                       eject 
0886 6CD7              ;===============================================================================
0887 6CD7              ; fatal_fn_err
0888 6CD7              ;
0889 6CD7              ; Entry is in 16-bit native mode.
0890 6CD7              ; Data bank register is set to bank $00.
0891 6CD7              ;
0892 6CD7              ; Inputs:       A - error code
0893 6CD7              ;               X - message #
0894 6CD7              ;               filename - contains name of file which caused the error (class 1)
0895 6CD7              ;
0896 6CD7              ; Outputs:      none
0897 6CD7              ;
0898 6CD7              ; Notes:        This routine does not return.
0899 6CD7              ;
0900 6CD7              ; Generate a fatal error while running under GS/OS.
0901 6CD7              ;===============================================================================
0902 6CD7
0903 6CD7              fatal_fn_err PROC 
0904 6CD7
0905 6CD7                       longa on
0906 6CD7                       longi on
0907 6CD7
0908 6CD7 A8                    tay                            ;save error # in Y
0909 6CD8 A9 FF BF              lda   #stack_top               ;set up correct stack
0910 6CDB 1B                    tcs   
0911 6CDC
0912 6CDC 5A                    phy                            ;error #
0913 6CDD DA                    phx                            ;message #
0914 6CDE AD 0C 7D              lda   |filename                ;get length word of filename
0915 6CE1 EB                    xba                            ;swap bytes to convert it to class 0 format
0916 6CE2 8D 0C 7D              sta   |filename
0917 6CE5 F4 00 00              pea   filename>>16             ;push ptr to substitution string
0918 6CE8 F4 0D 7D              pea   filename+1
0919 6CEB 22 A0 FC 01           jsl   report_fatal             ;fatal error - no return
0920 6CEF
0921 6CEF                       ENDP 
0922 6CEF
0923 6CEF
0924 6CEF
0925 6CEF                       eject 
0926 6CEF              ;===============================================================================
0927 6CEF              ; load_err_msgs
0928 6CEF              ;
0929 6CEF              ; Entry is in 16-bit native mode.
0930 6CEF              ; Exit is in 16-bit native mode.
0931 6CEF              ; Data bank register is set to bank $00 on entry and exit.
0932 6CEF              ; Direct register is set to $0000 on entry and exit.
0933 6CEF              ; Stack pointer is set to GQuit's stack on entry and exit.
0934 6CEF              ;
0935 6CEF              ; Inputs:       X - file eof
0936 6CEF              ;
0937 6CEF              ; Outputs:      c - 0 if no error ; 1 if error.
0938 6CEF              ;               A - error code if c=1
0939 6CEF              ;               e1_msg_address - load address of the error messages data
0940 6CEF              ;               perm_msg_size - size of permanent section of the file
0941 6CEF              ;               e1_patch1_adr - load address of first QuickDraw patch
0942 6CEF              ;               e1_patch2_adr - load address of second QuickDraw patch
0943 6CEF              ;
0944 6CEF              ; Notes:        Two QuickDraw patches have been added to the beginning of the
0945 6CEF              ;               error messages file.  This routine saves the load addresses of the
0946 6CEF              ;               patches and calculates the load address of the actual start of the
0947 6CEF              ;               error messages data.  The patches were put in the error messages file
0948 6CEF              ;               because they must be permanently resident in non-special memory and
0949 6CEF              ;               must not move.
0950 6CEF              ;
0951 6CEF              ; This routine calls the system loader's InitialLoad2 routine to load the error
0952 6CEF              ; messages file from memory.  The first word of the error messages data contains the size
0953 6CEF              ; in bytes of the permanent section of the file.  This value is used by GLoader to
0954 6CEF              ; shrink the segment allocated for the file after the temporary messages are
0955 6CEF              ; no longer needed.
0956 6CEF              ;===============================================================================
0957 6CEF
0958 6CEF              load_err_msgs PROC 
0959 6CEF
0960 6CEF                       longa on
0961 6CEF                       longi on
0962 6CEF
0963 6CEF A9 00 31              lda   #scm_id_type             ;segment ID type to use
0964 6CF2 20 BD 70              jsr   load_from_mem            ;call the loader
0965 6CF5 B0 3D                 bcs   done
0966 6CF7
0967 6CF7 AD F6 7C              lda   |load_adr                ;get load address of first QuickDraw patch
0968 6CFA 8F E1 D6 E1           sta   >e1_patch1_adr           ;and save
0969 6CFE AA                    tax   
0970 6CFF AD F8 7C              lda   |load_adr+2
0971 6D02 8F E3 D6 E1           sta   >e1_patch1_adr+2
0972 6D06 A8                    tay   
0973 6D07
0974 6D07 18                    clc   
0975 6D08 8A                    txa                            ;calculate load address of second QuickDraw patch
0976 6D09 69 0D 00              adc   #13
0977 6D0C 8F E5 D6 E1           sta   >e1_patch2_adr           ;and save
0978 6D10 AA                    tax   
0979 6D11 98                    tya   
0980 6D12 69 00 00              adc   #0
0981 6D15 8F E7 D6 E1           sta   >e1_patch2_adr+2
0982 6D19 A8                    tay   
0983 6D1A
0984 6D1A 18                    clc   
0985 6D1B 8A                    txa                            ;calculate load address of error messages data
0986 6D1C 69 0D 00              adc   #13
0987 6D1F 8F F3 D6 E1           sta   >e1_msg_address          ;and save for SCM
0988 6D23 85 00                 sta   <0
0989 6D25 98                    tya   
0990 6D26 69 00 00              adc   #0
0991 6D29 8F F5 D6 E1           sta   >e1_msg_address+2
0992 6D2D 85 02                 sta   <2
0993 6D2F
0994 6D2F A7 00                 lda   [<0]                     ;get size of permanent section of file
0995 6D31 8D DE 7C              sta   |perm_msg_size           ;and save
0996 6D34
0997 6D34 60           done     rts   
0998 6D35
0999 6D35                       ENDP 
1000 6D35
1001 6D35
1002 6D35
1003 6D35                       eject 
1004 6D35              ;===============================================================================
1005 6D35              ; load_gsosdev
1006 6D35              ;
1007 6D35              ; Entry is in 16-bit native mode.
1008 6D35              ; Exit is in 16-bit native mode.
1009 6D35              ; Data bank register is set to bank $00 on entry and exit.
1010 6D35              ; Direct register is set to $0000 on entry and exit.
1011 6D35              ; Stack pointer is set to GQuit's stack on entry and exit.
1012 6D35              ;
1013 6D35              ; Inputs:       X - file eof
1014 6D35              ;
1015 6D35              ; Outputs:      c - 0 if no error ; 1 if error.
1016 6D35              ;               A - error code if c=1
1017 6D35              ;               e1_dev_address - load address of the GS.OS.DEV file
1018 6D35              ;
1019 6D35              ; This routine calls the system loader's InitialLoad2 routine to load the
1020 6D35              ; GS.OS.DEV file from memory.  It then does a JSL to the entry address.
1021 6D35              ;===============================================================================
1022 6D35
1023 6D35              load_gsosdev PROC 
1024 6D35
1025 6D35                       longa on
1026 6D35                       longi on
1027 6D35
1028 6D35 A9 00 3F              lda   #dev_id_type             ;segment ID type to use
1029 6D38 20 BD 70              jsr   load_from_mem            ;call the loader
1030 6D3B B0 19                 bcs   done
1031 6D3D AD F8 7C              lda   |load_adr+2              ; get hi word of entry address
1032 6D40 8F ED D6 E1           sta   >e1_dev_address+2        ;save
1033 6D44 EB                    xba                            ; swap bytes
1034 6D45 8D 54 6D              sta   |goadr+2                 ; and store below
1035 6D48 AD F6 7C              lda   |load_adr                ; get lo word of entry address
1036 6D4B 8F EB D6 E1           sta   >e1_dev_address          ; save
1037 6D4F 8D 53 6D              sta   |goadr+1                 ; and store below
1038 6D52 22 1F 15 02  goadr    jsl   goadr                    ;*** Modified above to JSL to GS.OS.DEV
1039 6D56 60           done     rts   
1040 6D57
1041 6D57                       ENDP 
1042 6D57
1043 6D57
1044 6D57
1045 6D57                       eject 
1046 6D57              ;===============================================================================
1047 6D57              ; load_start_fst
1048 6D57              ;
1049 6D57              ; Entry is in 16-bit native mode.
1050 6D57              ; Exit is in 16-bit native mode.
1051 6D57              ; Data bank register is set to bank $00 on entry and exit.
1052 6D57              ; Direct register is set to $0000 on entry and exit.
1053 6D57              ; Stack pointer is set to GQuit's stack on entry and exit.
1054 6D57              ;
1055 6D57              ; Inputs:       X - file eof
1056 6D57              ;
1057 6D57              ; Outputs:      c - 0 if no error ; 1 if error.
1058 6D57              ;               A - error code if c=1
1059 6D57              ;               fst_address - load address of the start FST
1060 6D57              ;
1061 6D57              ; This routine calls the system loader's InitialLoad2 routine to load the start
1062 6D57              ; FST file from memory.  It then checks the FST's ID to see if it is the AppleShare
1063 6D57              ; FST and sets a flag if it is.  If the text splash screen is being put up,
1064 6D57              ; it then prints out the FST's message field.
1065 6D57              ;===============================================================================
1066 6D57
1067 6D57              load_start_fst PROC 
1068 6D57
1069 6D57                       longa on
1070 6D57                       longi on
1071 6D57
1072 6D57 A9 00 33              lda   #fst_id_type             ;segment ID type to use
1073 6D5A 20 BD 70              jsr   load_from_mem            ;call the loader
1074 6D5D B0 10                 bcs   done
1075 6D5F AD F6 7C              lda   |load_adr                ;save starting address for later
1076 6D62 8D 00 7D              sta   |fst_address
1077 6D65 AD F8 7C              lda   |load_adr+2
1078 6D68 8D 02 7D              sta   |fst_address+2
1079 6D6B 20 3F 6E              jsr   do_fst_stuff             ;check fst ID and maybe print comment field
1080 6D6E 18                    clc                            ;indicate no error
1081 6D6F 60           done     rts   
1082 6D70
1083 6D70                       ENDP 
1084 6D70
1085 6D70
1086 6D70
1087 6D70                       eject 
1088 6D70              ;===============================================================================
1089 6D70              ; load_boot_drvr
1090 6D70              ;
1091 6D70              ; Entry is in 16-bit native mode.
1092 6D70              ; Exit is in 16-bit native mode.
1093 6D70              ; Data bank register is set to bank $00 on entry and exit.
1094 6D70              ; Direct register is set to $0000 on entry and exit.
1095 6D70              ; Stack pointer is set to GQuit's stack on entry and exit.
1096 6D70              ;
1097 6D70              ; Inputs:       X - file eof
1098 6D70              ;
1099 6D70              ; Outputs:      c - 0 if no error ; 1 if error.
1100 6D70              ;               A - error code if c=1
1101 6D70              ;               e1_drvr_address - load address of the boot driver
1102 6D70              ;               e1_drvr_id - segment ID of boot driver
1103 6D70              ;
1104 6D70              ; This routine calls the system loader's InitialLoad2 routine to load the boot
1105 6D70              ; driver file from memory.
1106 6D70              ;===============================================================================
1107 6D70
1108 6D70              load_boot_drvr PROC 
1109 6D70
1110 6D70                       longa on
1111 6D70                       longi on
1112 6D70
1113 6D70 A9 00 39              lda   #drvr_id_type            ;segment ID type to use
1114 6D73 20 BD 70              jsr   load_from_mem            ;call the loader
1115 6D76 B0 16                 bcs   done
1116 6D78 AD F6 7C              lda   |load_adr                ;save starting address for
1117 6D7B 8F EF D6 E1           sta   >e1_drvr_address         ;device dispatcher
1118 6D7F AD F8 7C              lda   |load_adr+2
1119 6D82 8F F1 D6 E1           sta   >e1_drvr_address+2
1120 6D86 AF 77 D6 E1           lda   >e1_user_id              ;save user ID for device dispatcher
1121 6D8A 8F 75 D6 E1           sta   >e1_drvr_id
1122 6D8E 60           done     rts   
1123 6D8F
1124 6D8F                       ENDP 
1125 6D8F
1126 6D8F                       eject 
1127 6D8F              ;===============================================================================
1128 6D8F              ; load_fsts
1129 6D8F              ;
1130 6D8F              ; Entry is in 16-bit native mode.
1131 6D8F              ; Exit is in 16-bit native mode.
1132 6D8F              ; Data bank register is set to bank $00 on entry and exit.
1133 6D8F              ; Direct register is preserved.
1134 6D8F              ; Stack pointer is set to GQuit's stack on entry and exit.
1135 6D8F              ;
1136 6D8F              ; Inputs:       none
1137 6D8F              ;
1138 6D8F              ; Outputs:      c - 0 if FSTs loaded successfully ; 1 if not
1139 6D8F              ;               A - contains error code if c=1
1140 6D8F              ;               got_filename - 1 if got a filename for the error msg; 0 if not
1141 6D8F              ;
1142 6D8F              ; This routine installs all FSTs (except the start FST) in the FSTS subdirectory.
1143 6D8F              ; It then checks the FST's ID to see if it is the AppleShare FST.
1144 6D8F              ; If this is the initial boot of GS/OS and the text splash screen is being put
1145 6D8F              ; up, this routine will print out the comment field of each FST after it's
1146 6D8F              ; successfully loaded.
1147 6D8F              ;===============================================================================
1148 6D8F
1149 6D8F              load_fsts PROC 
1150 6D8F
1151 6D8F              ; set direct register to point to GS/OS direct page for calls to SCM
1152 6D8F
1153 6D8F 0B                    phd                            ;save direct register
1154 6D90 F4 00 BD              pea   direct_base              ;setup gsos direct page
1155 6D93 2B                    pld   
1156 6D94
1157 6D94              ; copy '*/SYSTEM/FSTS' into pathname buffer
1158 6D94
1159 6D94 A2 E9 7F              ldx   #fst_path
1160 6D97 20 FD 71              jsr   copy_to_buf
1161 6D9A
1162 6D9A              ; open the FSTS directory
1163 6D9A
1164 6D9A 22 A8 00 E1           _open1 open_parms1
1165 6DA4 90 03                 bcc   open_ok
1166 6DA6 4C 35 6E              jmp   got_err2
1167 6DA9              open_ok   
1168 6DA9
1169 6DA9              ; copy the reference number into the getdirentry and close parameter lists
1170 6DA9
1171 6DA9 AD 84 7C              lda   |open_ref
1172 6DAC 8D 92 7C              sta   |gde_ref
1173 6DAF 8D 8E 7C              sta   |close_ref
1174 6DB2
1175 6DB2              ; append a colon to the end of the directory pathname
1176 6DB2
1177 6DB2 AE 2E 7D              ldx   |path_buf                ; get length of pathname (class 1)
1178 6DB5 E8                    inx                            ; add 1 for colon
1179 6DB6 8E 2E 7D              stx   |path_buf                ; and store
1180 6DB9 8E F2 7C              stx   |path_len                ; and save for later
1181 6DBC E8                    inx   
1182 6DBD A9 3A 00              lda   #':'                     ; append a colon to end of pathname
1183 6DC0 9D 2E 7D              sta   |path_buf,x
1184 6DC3
1185 6DC3              ; intialize the directory entry index to 0
1186 6DC3
1187 6DC3 9C 98 7C              stz   |gde_disp
1188 6DC6
1189 6DC6              ; loop through the directory entries and install all valid FSTs
1190 6DC6
1191 6DC6              next_entry  
1192 6DC6 EE 98 7C              inc   |gde_disp                ; increment entry index
1193 6DC9
1194 6DC9 22 A8 00 E1           _getdirentry1 gde_parms1       ;get the next directory entry
1195 6DD3 B0 54                 bcs   got_err
1196 6DD5
1197 6DD5 AD BC 7C              lda   |gde_auxtype             ;get the entry's auxtype
1198 6DD8 30 EC                 bmi   next_entry               ;if hi bit is set, don't load file
1199 6DDA
1200 6DDA AD A0 7C              lda   |gde_filetype            ;get the entry's filetype
1201 6DDD C9 BD 00              cmp   #fst_ftype               ;is it an FST file?
1202 6DE0 D0 E4                 bne   next_entry               ;no - so skip it
1203 6DE2
1204 6DE2 20 13 72              jsr   make_full_path           ;create the full pathname of the file
1205 6DE5
1206 6DE5 F4 00 00              pea   startfst_name>>16        ; Address of start fst name
1207 6DE8 F4 66 7D              pea   startfst_name
1208 6DEB F4 00 00              pea   filename>>16             ; Address of entry's file name.
1209 6DEE F4 0C 7D              pea   filename
1210 6DF1 22 0A D3 E1           jsl   compare_string           ; Is the filename the start fst name?
1211 6DF5 90 CF                 bcc   next_entry               ; yes - so it was already loaded.
1212 6DF7
1213 6DF7 A9 01 00              lda   #1
1214 6DFA 8D F4 7C              sta   |iload_type              ; initial load using class 1 pathname
1215 6DFD A2 2E 7D              ldx   #path_buf                ; X gets lo word of pathname address.
1216 6E00 A0 00 00              ldy   #path_buf>>16            ; Y gets high word of pathname address.
1217 6E03 A9 00 33              lda   #fst_id_type             ; segment ID type
1218 6E06 20 DE 70              jsr   iload_file               ; load the FST
1219 6E09 B0 1B                 bcs   got_fn_err
1220 6E0B
1221 6E0B AE F6 7C              ldx   |load_adr                ;get FST's load address
1222 6E0E AC F8 7C              ldy   |load_adr+2
1223 6E11 22 DF DB E1           jsl   >add_fst                 ;notify SCM
1224 6E15 90 0A                 bcc   fst_added_ok
1225 6E17 C9 00 00              cmp   #0                       ;got an error - was it non-fatal?
1226 6E1A D0 0A                 bne   got_fn_err               ;no
1227 6E1C 20 22 71              jsr   unload_file              ;yes - so unload the FST
1228 6E1F 80 A5                 bra   next_entry               ;and continue
1229 6E21              fst_added_ok  
1230 6E21 20 3F 6E              jsr   do_fst_stuff             ;check fst ID and maybe print comment field
1231 6E24
1232 6E24 80 A0                 bra   next_entry               ;loop until done with all FST's
1233 6E26
1234 6E26              ; indicate that we have a filename for the error message then fall thru
1235 6E26
1236 6E26 EE FE 7C     got_fn_err inc   |got_filename
1237 6E29
1238 6E29              ; close FSTS directory
1239 6E29
1240 6E29              got_err   
1241 6E29 48                    pha                            ; save error code
1242 6E2A 22 A8 00 E1           _close1 close_parms1           ; close the directory
1243 6E34 68                    pla                            ; retrieve error code
1244 6E35
1245 6E35              ; if error code is 'end of directory' then don't report the error
1246 6E35              ; otherwise, we got a real error so report it
1247 6E35
1248 6E35              got_err2  
1249 6E35 2B                    pld                            ; restore direct register
1250 6E36 C9 61 00              cmp   #end_of_dir              ; end of directory error?
1251 6E39 F0 02                 beq   no_err                   ; yes - so not really an error
1252 6E3B 38                    sec                            ; indicate error
1253 6E3C 60                    rts   
1254 6E3D
1255 6E3D              no_err    
1256 6E3D 18                    clc                            ; indicate no error
1257 6E3E 60                    rts   
1258 6E3F                       ENDP 
1259 6E3F
1260 6E3F
1261 6E3F
1262 6E3F                       eject 
1263 6E3F              ;===============================================================================
1264 6E3F              ; do_fst_stuff
1265 6E3F              ;
1266 6E3F              ; Entry is in 16-bit native mode.
1267 6E3F              ; Exit is in 16-bit native mode.
1268 6E3F              ; Data bank register is set to bank $00 on entry and exit.
1269 6E3F              ; Direct register is preserved.
1270 6E3F              ; Stack pointer is set to GQuit's stack on entry and exit.
1271 6E3F              ;
1272 6E3F              ; Inputs:       load_adr - starting address of the FST
1273 6E3F              ;
1274 6E3F              ; Outputs:      none
1275 6E3F              ;
1276 6E3F              ; Notes:        The direct register is set to point to load_adr which
1277 6E3F              ;               contains the starting address of the FST.  This is done so that
1278 6E3F              ;               indirect addressing can be used to access the contents of the
1279 6E3F              ;               FST header.
1280 6E3F              ;
1281 6E3F              ; This routine checks the FST's ID to see if it is the AppleShare FST and sets
1282 6E3F              ; a flag if it is.
1283 6E3F              ; If the text splash screen is being put up, this routine will then print out
1284 6E3F              ; the message field of the FST header. The message field is immediately after
1285 6E3F              ; the name field in the FST header.  Both fields begin with a length byte.
1286 6E3F              ;===============================================================================
1287 6E3F
1288 6E3F              do_fst_stuff PROC 
1289 6E3F
1290 6E3F                       longa on
1291 6E3F                       longi on
1292 6E3F
1293 6E3F 0B                    phd                            ;save direct register
1294 6E40 F4 F6 7C              pea   load_adr                 ;set direct register to load_adr
1295 6E43 2B                    pld                            ;so we can use indirect addressing
1296 6E44
1297 6E44 A0 0C 00              ldy   #fst_id_offset           ;offset to ID field in FST header
1298 6E47 B7 00                 lda   [<0],y                   ;get the FST's ID
1299 6E49 C9 0D 00              cmp   #appleshare_id           ;is it AppleShare?
1300 6E4C D0 04                 bne   cont                     ;no
1301 6E4E 8F 8B D6 E1           sta   >e1_appleshare           ;yes - so set flag
1302 6E52              cont      
1303 6E52 AD F0 7C              lda   |text_flag               ;should we put up the fst message?
1304 6E55 F0 1A                 beq   skip_msg                 ;no
1305 6E57 18                    clc   
1306 6E58 A0 24 00              ldy   #fst_name_offset         ;get offset to name string
1307 6E5B B7 00                 lda   [<0],y                   ;get length byte of name string
1308 6E5D 29 FF 00              and   #$00ff                   ;mask off hi byte
1309 6E60 1A                    inc   a                        ;add 1 for length byte of name string
1310 6E61 1A                    inc   a                        ;and 1 for length byte of message string
1311 6E62 69 24 00              adc   #fst_name_offset         ;add name string offset
1312 6E65 65 00                 adc   <0                       ;add start address of fst
1313 6E67 AA                    tax                            ;to create the address of the first
1314 6E68 A5 02                 lda   <2                       ;character of the message
1315 6E6A 69 00 00              adc   #0
1316 6E6D A8                    tay   
1317 6E6E 20 C3 72              jsr   print_message            ;print the message
1318 6E71              skip_msg  
1319 6E71 2B                    pld                            ;restore direct register
1320 6E72 60                    rts   
1321 6E73
1322 6E73                       ENDP 
1323 6E73
1324 6E73
1325 6E73
1326 6E73                       eject 
1327 6E73              ;===============================================================================
1328 6E73              ; load_setup_files
1329 6E73              ;
1330 6E73              ; Entry is in 16-bit native mode.
1331 6E73              ; Exit is in 16-bit native mode.
1332 6E73              ; Data bank register is set to bank $00 on entry and exit.
1333 6E73              ;
1334 6E73              ; Inputs:       none
1335 6E73              ;
1336 6E73              ; Outputs:      c - 0 if no error ; 1 if error.
1337 6E73              ;               A - error code if c=1
1338 6E73              ;               got_filename - 1 if got a filename for the error msg; 0 if not
1339 6E73              ;
1340 6E73              ; This routine will load and execute all setup files in */SYSTEM/SYSTEM.SETUP
1341 6E73              ; except for the TOOL.SETUP and RESOURCE.MGR files which were already loaded
1342 6E73              ; and executed.
1343 6E73              ;===============================================================================
1344 6E73
1345 6E73              load_setup_files PROC  
1346 6E73
1347 6E73                       longa on
1348 6E73                       longi on
1349 6E73
1350 6E73
1351 6E73              ; first, copy '*/SYSTEM/SYSTEM.SETUP/' into pathname buffer
1352 6E73
1353 6E73 A2 F8 7F              ldx   #setup_path              ; get address of string
1354 6E76 20 FD 71              jsr   copy_to_buf
1355 6E79 AD 2E 7D              lda   |path_buf                ; get length of pathname (class 1)
1356 6E7C 8D F2 7C              sta   |path_len                ; and save for later
1357 6E7F
1358 6E7F              ; initialize the directory entry index to 0
1359 6E7F
1360 6E7F 9C 98 7C              stz   |gde_disp
1361 6E82
1362 6E82              ; loop through the directory entries and load and execute all valid setup files
1363 6E82              ;
1364 6E82              ; Note that we must close the directory before we execute each setup file and
1365 6E82              ; then reopen the directory after the file has executed since setup files can
1366 6E82              ; do a CloseAll.
1367 6E82
1368 6E82              open_setup  
1369 6E82 AD F2 7C              lda   |path_len                ; get length of pathname
1370 6E85 3A                    dec   a                        ; subtract 1 for trailing colon
1371 6E86 8D 2E 7D              sta   |path_buf                ; and store
1372 6E89
1373 6E89 22 A8 00 E1           _open1 open_parms1             ; open the directory file.
1374 6E93 B0 61                 bcs   bcs_setuperr2
1375 6E95
1376 6E95 AD 84 7C              lda   |open_ref                ; copy reference number into
1377 6E98 8D 92 7C              sta   |gde_ref                 ; getdirentry parameter list
1378 6E9B 8D 8E 7C              sta   |close_ref               ; and close parameter list
1379 6E9E
1380 6E9E              next_entry  
1381 6E9E EE 98 7C              inc   |gde_disp                ; increment entry index
1382 6EA1
1383 6EA1 22 A8 00 E1           _getdirentry1 gde_parms1       ;get the next directory entry
1384 6EAB B0 5D                 bcs   setuperr
1385 6EAD
1386 6EAD AD BC 7C              lda   |gde_auxtype             ;get the entry's auxtype
1387 6EB0 30 EC                 bmi   next_entry               ;if hi bit is set, don't load file
1388 6EB2
1389 6EB2 9C D2 7C              stz   |temp_setup              ;initialize flag for permanent setup file
1390 6EB5
1391 6EB5 AD A0 7C              lda   |gde_filetype            ;get the entry's filetype
1392 6EB8 C9 B6 00              cmp   #perm_ftype              ;is it a permanent setup file?
1393 6EBB F0 08                 beq   cont                     ;yes
1394 6EBD C9 B7 00              cmp   #temp_ftype              ;is it a temporary setup file?
1395 6EC0 D0 DC                 bne   next_entry               ;no - so skip it
1396 6EC2 EE D2 7C              inc   |temp_setup              ;indicate that the setup file is temporary
1397 6EC5              cont      
1398 6EC5 20 13 72              jsr   make_full_path           ;create full pathname of file
1399 6EC8 F4 00 00              pea   toolsetup_name>>16       ; Address of 'TOOL.SETUP'.
1400 6ECB F4 4F 7F              pea   toolsetup_name
1401 6ECE F4 00 00              pea   filename>>16             ; Address of entry's file name.
1402 6ED1 F4 0C 7D              pea   filename
1403 6ED4 22 0A D3 E1           jsl   compare_string           ; Is the filename 'TOOL.SETUP'?
1404 6ED8 90 C4                 bcc   next_entry               ; yes - so it was already loaded.
1405 6EDA
1406 6EDA F4 00 00              pea   resmgr_name>>16          ; Address of 'RESOURCE.MGR'.
1407 6EDD F4 5B 7F              pea   resmgr_name
1408 6EE0 F4 00 00              pea   filename>>16             ; Address of entry's file name.
1409 6EE3 F4 0C 7D              pea   filename
1410 6EE6 22 0A D3 E1           jsl   compare_string           ; Is the filename 'RESOURCE.MGR'?
1411 6EEA 90 B2                 bcc   next_entry               ; yes - so it was already loaded.
1412 6EEC
1413 6EEC 22 A8 00 E1           _close1 close_parms1           ; close the setup directory
1414 6EF6 B0 24        bcs_setuperr2 bcs   setuperr2
1415 6EF8
1416 6EF8 A2 2E 7D              ldx   #path_buf                ; X gets lo word of pathname address.
1417 6EFB A0 00 00              ldy   #path_buf>>16            ; Y gets high word of pathname address.
1418 6EFE 20 1F 6F              jsr   load_setup               ; Go load and run the setup file.
1419 6F01 B0 03                 bcs   got_fn_err
1420 6F03 4C 82 6E              jmp   open_setup               ; loop if no error
1421 6F06
1422 6F06              ; indicate that we have a filename for the error message
1423 6F06
1424 6F06 EE FE 7C     got_fn_err inc   |got_filename
1425 6F09 60                    rts   
1426 6F0A
1427 6F0A              ; close the SYSTEM.SETUP directory and check the error code
1428 6F0A              ; if error code is 'end of directory' then don't report the error
1429 6F0A
1430 6F0A              setuperr  
1431 6F0A 48                    pha                            ; save error code
1432 6F0B 22 A8 00 E1           _close1 close_parms1           ; close the setup directory.
1433 6F15 68                    pla                            ; retrieve error code
1434 6F16 C9 61 00              cmp   #end_of_dir              ; end of directory error?
1435 6F19 F0 02                 beq   nosetuperr               ; yes - so not really an error
1436 6F1B 38                    sec                            ; indicate error
1437 6F1C 60           setuperr2 rts   
1438 6F1D
1439 6F1D 18           nosetuperr clc                          ; indicate no error
1440 6F1E 60                    rts   
1441 6F1F
1442 6F1F                       ENDP 
1443 6F1F
1444 6F1F
1445 6F1F
1446 6F1F                       eject 
1447 6F1F              ;===============================================================================
1448 6F1F              ; load_setup
1449 6F1F              ;
1450 6F1F              ; Entry is in 16-bit native mode.
1451 6F1F              ; Exit is in 16-bit native mode.
1452 6F1F              ; Data bank register is set to bank $00 on entry and exit.
1453 6F1F              ; Direct register is preserved.
1454 6F1F              ;
1455 6F1F              ; Inputs:       X - low word of pathname address
1456 6F1F              ;               Y - high word of pathname address
1457 6F1F              ;               temp_setup - 0 if the setup file is permanent
1458 6F1F              ;                            <>0 if the setup file is temporary
1459 6F1F              ;
1460 6F1F              ; Outputs:      c - 0 if no error ; 1 if error
1461 6F1F              ;               A - error code if c=1
1462 6F1F              ;
1463 6F1F              ; This routine will load and execute permanent and temporary setup files.
1464 6F1F              ;
1465 6F1F              ; The Direct and Stack registers will be set to point to the starting and
1466 6F1F              ; ending address respectively of the zero page segment allocated by the system
1467 6F1F              ; loader via the InitialLoad call.  If the InitialLoad of the setup file
1468 6F1F              ; returns a zero in the zero page starting address parameter, then a zero page
1469 6F1F              ; segment will be allocated for the setup file and will be deallocated after
1470 6F1F              ; the setup file has executed.
1471 6F1F              ;
1472 6F1F              ; On entry to the setup program the A register will contain the user ID for
1473 6F1F              ; the program, and X and Y will be zeroed.
1474 6F1F              ;
1475 6F1F              ; A word of 0 will be pushed on the stack just before control is passed to the setup
1476 6F1F              ; program.  If a permanent setup program decides that it wants to be shutdown, it
1477 6F1F              ; should set the low bit of the word on the stack.  The setup program will then be
1478 6F1F              ; shutdown when control returns to load_setup.  Temporary setup files will always
1479 6F1F              ; be shutdown after they have executed.
1480 6F1F              ;===============================================================================
1481 6F1F
1482 6F1F              load_setup PROC 
1483 6F1F
1484 6F1F                       longa on
1485 6F1F                       longi on
1486 6F1F
1487 6F1F 0B                    phd                            ; save our direct register.
1488 6F20
1489 6F20 A9 01 00              lda   #1
1490 6F23 8D F4 7C              sta   |iload_type              ; initial load using class 1 pathname
1491 6F26 A9 00 A0              lda   #setup_id_type           ; get proper user ID.
1492 6F29 20 DE 70              jsr   iload_file               ; Go load the file pointed to by X,Y.
1493 6F2C B0 39                 bcs   exit
1494 6F2E
1495 6F2E AD F8 7C              lda   |load_adr+2              ; get hi word of entry address
1496 6F31 EB                    xba                            ; swap bytes
1497 6F32 8D 50 6F              sta   goadr+2                  ; and store below
1498 6F35 AD F6 7C              lda   |load_adr                ; get lo word of entry address
1499 6F38 8D 4F 6F              sta   goadr+1                  ; and store below
1500 6F3B
1501 6F3B 22 E8 DE E0           jsl   alloc_user_zp            ; set file's direct register
1502 6F3F B0 26                 bcs   exit
1503 6F41 BA                    tsx                            ; temporarily save our S in X.
1504 6F42 1B                    tcs                            ; set file's stack pointer
1505 6F43 DA                    phx                            ; Save our S on the file's stack.
1506 6F44 8B                    phb                            ; Save our Data Bank reg on file's stack.
1507 6F45
1508 6F45 AF 77 D6 E1           lda   >e1_user_id              ; Setup program gets his id from A reg.
1509 6F49 A2 00 00              ldx   #0                       ; Zero x,y as we would for an application...
1510 6F4C 9B                    txy   
1511 6F4D DA                    phx                            ; push a flag word of 0 on the stack
1512 6F4E
1513 6F4E 22 00 00 04  goadr    jsl   goadr                    ;*** Modified above to JSL to setup prog
1514 6F52
1515 6F52 68                    pla                            ; retrieve the flag word from the stack
1516 6F53 AB                    plb                            ; Restore our data bank register.
1517 6F54 FA                    plx                            ; restore our S register.
1518 6F55 9A                    txs   
1519 6F56
1520 6F56 4A                    lsr   a                        ; does the setup file want to be shutdown?
1521 6F57 B0 05                 bcs   shutdown                 ; yes
1522 6F59 AD D2 7C              lda   temp_setup               ; was it a temporary setup file?
1523 6F5C F0 05                 beq   cont                     ; no - so don't do a shutdown call
1524 6F5E 20 22 71     shutdown jsr   unload_file
1525 6F61 B0 04                 bcs   exit
1526 6F63
1527 6F63 22 F8 D4 E1  cont     jsl   dispose_user_zp          ; get rid of file's zero page segment
1528 6F67
1529 6F67 2B           exit     pld                            ; restore our direct register
1530 6F68 60                    rts                            ; c holds error condition ; A holds error        code.
1531 6F69                       ENDP 
1532 6F69
1533 6F69
1534 6F69
1535 6F69                       eject 
1536 6F69              ;===============================================================================
1537 6F69              ; load_da_files
1538 6F69              ;
1539 6F69              ; Entry is in 16-bit native mode.
1540 6F69              ; Exit is in 16-bit native mode.
1541 6F69              ; Data bank register is set to bank $00 on entry and exit.
1542 6F69              ;
1543 6F69              ; Inputs:       none
1544 6F69              ;
1545 6F69              ; Outputs:      c - 0 if no error ; 1 if error
1546 6F69              ;               A - error code if c=1
1547 6F69              ;               got_filename - 1 if got a filename for the error msg; 0 if not
1548 6F69              ;
1549 6F69              ; This routine will install both Classic and New Desk Accessories in the
1550 6F69              ; */SYSTEM/DESK.ACCS subdirectory.  If the maximum number of CDAs have been
1551 6F69              ; installed, it will stop installing CDAs but will continue installing NDAs.
1552 6F69              ;===============================================================================
1553 6F69
1554 6F69              load_da_files PROC 
1555 6F69
1556 6F69                       longa on
1557 6F69                       longi on
1558 6F69
1559 6F69
1560 6F69              ; first, copy the pathname '*/SYSTEM/DESK.ACCS/' into pathname buffer
1561 6F69
1562 6F69 A2 56 80              ldx   #da_path                 ; get address of string
1563 6F6C 20 FD 71              jsr   copy_to_buf
1564 6F6F AD 2E 7D              lda   |path_buf                ; get length of pathname (class 1)
1565 6F72 8D F2 7C              sta   |path_len                ; and save for later
1566 6F75
1567 6F75              ; open the DESK.ACCS subdirectory
1568 6F75
1569 6F75 22 A8 00 E1           _open1 open_parms1             ; open the directory file.
1570 6F7F B0 50                 bcs   DA_open_err
1571 6F81
1572 6F81 AD 84 7C              lda   |open_ref                ; copy reference number into
1573 6F84 8D 92 7C              sta   |gde_ref                 ; getdirentry parameter list
1574 6F87 8D 8E 7C              sta   |close_ref               ; and close parameter list
1575 6F8A
1576 6F8A              ; initialize the directory entry index to 0
1577 6F8A
1578 6F8A 9C 98 7C              stz   |gde_disp
1579 6F8D
1580 6F8D              ; loop through the directory entries and install all valid DA files
1581 6F8D
1582 6F8D              next_entry  
1583 6F8D EE 98 7C              inc   |gde_disp                ; increment entry index
1584 6F90
1585 6F90 22 A8 00 E1           _getdirentry1 gde_parms1       ;get the next directory entry
1586 6F9A B0 3E                 bcs   DAerr
1587 6F9C
1588 6F9C AD BC 7C              lda   |gde_auxtype             ;get the entry's auxtype
1589 6F9F 30 EC                 bmi   next_entry               ;if hi bit is set, don't load file
1590 6FA1
1591 6FA1 AD A0 7C              lda   |gde_filetype            ;get the entry's filetype
1592 6FA4 C9 B8 00              cmp   #nda_ftype               ;is it a New DA file?
1593 6FA7 F0 0A                 beq   cont                     ;yes
1594 6FA9 C9 B9 00              cmp   #cda_ftype               ;is it a Classic DA file?
1595 6FAC D0 DF                 bne   next_entry               ;no - so skip it
1596 6FAE AE DA 7C              ldx   |skip_cdas               ;have we installed the max # of CDA's?
1597 6FB1 D0 DA                 bne   next_entry               ;yes - so skip this CDA
1598 6FB3              cont      
1599 6FB3 8D D4 7C              sta   |da_type                 ;save filetype for later
1600 6FB6 20 13 72              jsr   make_full_path           ;create full pathname of file
1601 6FB9
1602 6FB9              loadit    
1603 6FB9 A2 2E 7D              ldx   #path_buf                ; X gets lo word of pathname address
1604 6FBC A0 00 00              ldy   #path_buf>>16            ; Y gets high word of pathname address
1605 6FBF 20 F4 6F              jsr   load_da                  ; go install the desk accessory
1606 6FC2 90 C9                 bcc   next_entry               ; loop if no error
1607 6FC4 C9 01 05              cmp   #$0501                   ; 'too many CDAs' error?
1608 6FC7 D0 0E                 bne   got_fn_err               ; no - so can't continue
1609 6FC9
1610 6FC9              ; We got a 'too many CDAs' error while installing a CDA, so shutdown the CDA
1611 6FC9              ; we got the error on and quit installing CDAs but continue installing NDAs.
1612 6FC9
1613 6FC9 20 22 71              jsr   unload_file              ; shut down the CDA
1614 6FCC EE DA 7C              inc   |skip_cdas               ; set flag so no more CDAs will be installed
1615 6FCF 80 BC                 bra   next_entry
1616 6FD1
1617 6FD1
1618 6FD1              ; got an error trying to open the DESK.ACCS directory
1619 6FD1              ; if error code is 'file not found' then don't report the error
1620 6FD1
1621 6FD1 C9 46 00     DA_open_err cmp   #file_not_found       ; 'file not found' error?
1622 6FD4 F0 1C                 beq   noDAerr                  ; yes - so not really an error
1623 6FD6 60                    rts                            ; no - so return the error
1624 6FD7
1625 6FD7              ; indicate that we have a filename for the error message then fall thru
1626 6FD7
1627 6FD7 EE FE 7C     got_fn_err inc   |got_filename
1628 6FDA
1629 6FDA              ; close the DESK.ACCS directory and check the error code
1630 6FDA              ; if error code is 'end of directory' then don't report the error
1631 6FDA              ; if error code is 'version error' then don't report the error since this is
1632 6FDA              ; returned by the GetDirEntry call and means that DESK.ACCS isn't a directory
1633 6FDA
1634 6FDA              DAerr     
1635 6FDA 48                    pha                            ; save error code
1636 6FDB 22 A8 00 E1           _close1 close_parms1           ; close the DA directory.
1637 6FE5 68                    pla                            ; retrieve error code
1638 6FE6 C9 61 00              cmp   #end_of_dir              ; 'end of directory' error?
1639 6FE9 F0 07                 beq   noDAerr                  ; yes - so not really an error
1640 6FEB C9 4A 00              cmp   #version_error           ; 'not a directory' error?
1641 6FEE F0 02                 beq   noDAerr                  ; yes - so not really an error
1642 6FF0 38                    sec                            ; indicate error
1643 6FF1 60                    rts   
1644 6FF2
1645 6FF2 18           noDAerr  clc                            ; indicate no error
1646 6FF3 60                    rts   
1647 6FF4
1648 6FF4                       ENDP 
1649 6FF4
1650 6FF4
1651 6FF4
1652 6FF4                       eject 
1653 6FF4              ;===============================================================================
1654 6FF4              ; load_da
1655 6FF4              ;
1656 6FF4              ; Entry is in 16-bit native mode.
1657 6FF4              ; Exit is in 16-bit native mode.
1658 6FF4              ; Data bank register is set to bank $00 on entry and exit.
1659 6FF4              ;
1660 6FF4              ; Inputs:       X - low word of pathname address
1661 6FF4              ;               Y - high word of pathname address
1662 6FF4              ;               da_type - desk accessory file type
1663 6FF4              ;
1664 6FF4              ; Outputs:      c - 0 if no error ; 1 if error
1665 6FF4              ;               A - error code if c=1
1666 6FF4              ;
1667 6FF4              ; Notes:        If a handle cannot be found for an installed DA, an
1668 6FF4              ;               error code of zero is returned since the memory manager
1669 6FF4              ;               FindHandle call does not return an error when no handle
1670 6FF4              ;               is found for a given address.
1671 6FF4              ;
1672 6FF4              ; This routine will load and install the desk accessory file designated by
1673 6FF4              ; the pathname pointed to by X and Y.  Da_type contains the filetype of the
1674 6FF4              ; desk accessory (ie, New Desk Accessory vs Classic Desk Accessory).
1675 6FF4              ;===============================================================================
1676 6FF4
1677 6FF4              load_da  PROC 
1678 6FF4
1679 6FF4                       longa on
1680 6FF4                       longi on
1681 6FF4
1682 6FF4 A9 01 00              lda   #1
1683 6FF7 8D F4 7C              sta   |iload_type              ; initial load using class 1 pathname
1684 6FFA A9 00 50              lda   #DA_id_type              ; get proper user ID type.
1685 6FFD 20 DE 70              jsr   iload_file               ; Go load the file pointed to by X,Y.
1686 7000 B0 37                 bcs   exit
1687 7002
1688 7002 48                    pha                            ; Now get the handle to the DA.
1689 7003 48                    pha                            ; Push space for the handle result.
1690 7004 AD F8 7C              lda   |load_adr+2              ; Push hi word of address of DA.
1691 7007 48                    pha   
1692 7008 AD F6 7C              lda   |load_adr                ; Push low word of address of DA.
1693 700B 48                    pha   
1694 700C A2 02 1A 22           _findhandle                    ; Find the handle to the DA just loaded.
1695 7013 A3 01                 lda   1,s                      ; Make sure the handle is not null
1696 7015 03 02                 ora   2,s                      ; indicating no handle to the DA!
1697 7017 D0 04                 bne   foundhandle              ; Branch if handle found.
1698 7019 68                    pla                            ; No handle! Clear stack and return error!
1699 701A 68                    pla                            ; ** Note that the error code returned is 0!
1700 701B 38                    sec                            ; Denote error.
1701 701C 60                    rts                            ; and return
1702 701D
1703 701D              foundhandle  
1704 701D AD D4 7C              lda   |da_type                 ; get the filetype.
1705 7020 C9 B8 00              cmp   #nda_ftype               ; is it a New DA file?
1706 7023 D0 08                 bne   its_cda                  ; no - it's a Classic DA file.
1707 7025 A2 05 0E 22           _installNDA                    ; Install the New desk accessory.
1708 702C 60                    rts                            ; and return
1709 702D
1710 702D A2 05 0F 22  its_cda  _installCDA                    ; Install the Classic desk accessory.
1711 7034 90 03                 bcc   exit
1712 7036              ;*** Note - if installCDA gets an error, it returns a random error code.
1713 7036              ;*** Since the only error it checks for is 'too many DAs' we can stuff the
1714 7036              ;*** correct error code in A ourselves.
1715 7036 A9 01 05              lda   #$0501                   ; fix the error code
1716 7039 60           exit     rts   
1717 703A
1718 703A                       ENDP 
1719 703A
1720 703A
1721 703A
1722 703A                       eject 
1723 703A              ;===============================================================================
1724 703A              ; alloc_boot_mem
1725 703A              ;
1726 703A              ; Entry is in 16-bit native mode.
1727 703A              ; Exit is in 16-bit native mode.
1728 703A              ; Data bank register is set to bank $00 on entry and exit.
1729 703A              ; Direct register is preserved.
1730 703A              ;
1731 703A              ; Inputs:       e1_os_mem_id - contains the ID used by GLDR and GQuit when
1732 703A              ;                              allocating memory segments.
1733 703A              ;
1734 703A              ; Outputs:      c - 0 if no error, 1 if error
1735 703A              ;               A - error code if c=1
1736 703A              ;
1737 703A              ; Allocate the memory used by GLoader to ensure that nobody else
1738 703A              ; tries to allocate it during the boot process.
1739 703A              ; The segment is allocated with a $32xx segment ID.
1740 703A              ;===============================================================================
1741 703A
1742 703A              alloc_boot_mem PROC 
1743 703A
1744 703A                       import org_dummy_2
1745 703A
1746 703A              GLoader_len equ   gldr_obj_pad-gldr_obj_pstn
1747 703A
1748 703A                       longa on
1749 703A                       longi on
1750 703A
1751 703A 48                    pha                            ;space for handle result
1752 703B 48                    pha   
1753 703C F4 00 00              pea   GLoader_len>>16          ;hi word of seg size
1754 703F F4 00 1A              pea   |GLoader_len             ;lo word of seg size
1755 7042 AF 55 D6 E1           lda   >e1_os_mem_id
1756 7046 48                    pha                            ;segment user id
1757 7047 F4 13 40              pea   %0100000000010011        ;seg attributes word (fixed, noCross, fixed address, fixed bank)
1758 704A F4 00 00              pea   $0000                    ;ask for bank 0
1759 704D F4 00 68              pea   org_dummy_1              ;(GLoader's starting address)
1760 7050 A2 02 09 22           _newhandle 
1761 7057 FA                    plx                            ;retrieve handle for disposal later
1762 7058 8E E2 7C              stx   |boot_hndl
1763 705B FA                    plx   
1764 705C 8E E4 7C              stx   |boot_hndl+2
1765 705F 60                    rts                            ;with C and Acc unchanged from NewHandle call
1766 7060
1767 7060                       ENDP 
1768 7060
1769 7060
1770 7060
1771 7060                       eject 
1772 7060              ;===============================================================================
1773 7060              ; alloc_work_mem
1774 7060              ;
1775 7060              ; Entry is in 16-bit native mode.
1776 7060              ; Exit is in 16-bit native mode.
1777 7060              ; Data bank register is set to bank $00 on entry and exit.
1778 7060              ; Direct register is preserved.
1779 7060              ;
1780 7060              ; Inputs:       e1_os_mem_id - contains the ID used by GLDR and GQuit when
1781 7060              ;                              allocating memory segments.
1782 7060              ;
1783 7060              ; Outputs:      c - 0 if no error, 1 if error
1784 7060              ;               A - error code if c=1
1785 7060              ;               buf_hndl - contains the handle to the allocated segment
1786 7060              ;               buf_ptr - contains the pointer to the allocated segment
1787 7060              ;
1788 7060              ; Allocate a 64K memory segment outside of banks 0 and 1.
1789 7060              ; The segment is allocated with a $32xx segment ID.
1790 7060              ;===============================================================================
1791 7060
1792 7060              alloc_work_mem PROC 
1793 7060
1794 7060                       longa on
1795 7060                       longi on
1796 7060
1797 7060 48                    pha                            ;space for handle result
1798 7061 48                    pha   
1799 7062 F4 01 00              pea   work_seg_size>>16        ;hi word of seg size
1800 7065 F4 00 00              pea   |work_seg_size           ;lo word of seg size
1801 7068 AF 55 D6 E1           lda   >e1_os_mem_id
1802 706C 48                    pha                            ;segment user id
1803 706D F4 19 80              pea   boot_attrib              ;seg attributes word
1804 7070 F4 04 00              pea   $0004                    ;ask for bank 4 {gab - 04/23/90}
1805 7073 F4 00 00              pea   $0000
1806 7076 A2 02 09 22           _newhandle 
1807 707D B0 1C                 bcs   done                     ;if c=1, error in A
1808 707F
1809 707F 0B                    phd                            ;save direct register
1810 7080 3B                    tsc   
1811 7081 5B                    tcd                            ;point direct register at stack
1812 7082 A5 03                 lda   <3                       ;save handle to the memory segment
1813 7084 8D E6 7C              sta   |buf_hndl
1814 7087 A5 05                 lda   <5
1815 7089 8D E8 7C              sta   |buf_hndl+2
1816 708C
1817 708C A7 03                 lda   [<3]                     ;dereference handle
1818 708E 8D EA 7C              sta   |buf_ptr
1819 7091 A0 02 00              ldy   #2
1820 7094 B7 03                 lda   [<3],y
1821 7096 8D EC 7C              sta   |buf_ptr+2
1822 7099
1823 7099 2B                    pld                            ;restore direct register
1824 709A 18                    clc                            ;indicate no error
1825 709B
1826 709B FA           done     plx                            ;pull handle off stack
1827 709C FA                    plx   
1828 709D 60                    rts   
1829 709E
1830 709E                       ENDP 
1831 709E
1832 709E
1833 709E
1834 709E                       eject 
1835 709E              ;===============================================================================
1836 709E              ; read_the_file
1837 709E              ;
1838 709E              ; Entry is in 16-bit native mode.
1839 709E              ; Exit is in 16-bit native mode.
1840 709E              ; Data bank register is set to bank $00 on entry and exit.
1841 709E              ; Direct register is set to $0000 on entry and exit.
1842 709E              ; Stack pointer is set to GQuit's stack on entry and exit.
1843 709E              ;
1844 709E              ; Inputs:       X - low word of address of partial pathname of file to read
1845 709E              ;               Y - high word of address of partial pathname of file to read
1846 709E              ;
1847 709E              ; Outputs:      c - 0 if no error ; 1 if error.
1848 709E              ;               A - error code if c=1
1849 709E              ;               X - lo word of file's EOF
1850 709E              ;               Y - hi word of file's EOF
1851 709E              ;               filetype - file's filetype
1852 709E              ;               auxtype - file's auxtype
1853 709E              ;
1854 709E              ; This routine calls the ReadInFile routine in the boot code to read in a file.
1855 709E              ;===============================================================================
1856 709E
1857 709E              read_the_file PROC 
1858 709E
1859 709E                       longa on
1860 709E                       longi on
1861 709E
1862 709E 48                    pha                            ;8 byte space for results
1863 709F 48                    pha   
1864 70A0 48                    pha   
1865 70A1 48                    pha   
1866 70A2 5A                    phy                            ;ptr to partial pathname (input)
1867 70A3 DA                    phx   
1868 70A4 AD EC 7C              lda   |buf_ptr+2               ;pointer to mem buffer
1869 70A7 48                    pha   
1870 70A8 AD EA 7C              lda   |buf_ptr
1871 70AB 48                    pha   
1872 70AC A2 04 00              ldx   #4                       ;offset to ReadInFile routine
1873 70AF FC 00 20              jsr   (boot_obj_pstn,x)        ;Read in the file
1874 70B2 FA                    plx                            ;get filetype
1875 70B3 8E FA 7C              stx   |filetype                ;and save
1876 70B6 FA                    plx                            ;get auxtype
1877 70B7 8E FC 7C              stx   |auxtype                 ;and save
1878 70BA FA                    plx                            ;get lo word of eof
1879 70BB 7A                    ply                            ;get hi word of eof
1880 70BC 60                    rts   
1881 70BD
1882 70BD                       ENDP 
1883 70BD
1884 70BD
1885 70BD
1886 70BD                       eject 
1887 70BD              ;===============================================================================
1888 70BD              ; load_from_mem
1889 70BD              ;
1890 70BD              ; Entry is in 16-bit native mode.
1891 70BD              ; Exit is in 16-bit native mode.
1892 70BD              ; Data bank register is set to bank $00 on entry and exit.
1893 70BD              ; Direct register is set to $0000 on entry and exit.
1894 70BD              ; Stack pointer is set to GQuit's stack on entry and exit.
1895 70BD              ;
1896 70BD              ; Inputs:       X - file eof
1897 70BD              ;               A - segment ID type
1898 70BD              ;
1899 70BD              ; Outputs:      c - 0 if no error ; 1 if error.
1900 70BD              ;               A - error code if c=1
1901 70BD              ;
1902 70BD              ; This routine calls the system loader's InitialLoad2 routine to load a
1903 70BD              ; file from memory.
1904 70BD              ;===============================================================================
1905 70BD
1906 70BD              load_from_mem PROC 
1907 70BD
1908 70BD                       longa on
1909 70BD                       longi on
1910 70BD
1911 70BD              ;set up table of address of segment in memory and length for special iload.
1912 70BD              ;note: segment must be less than 64K-48 bytes !!!!!!!!!!!!!!!!!
1913 70BD              ;
1914 70BD              ;special iload info table is as follows
1915 70BD              ;               dc      i4'load_file_address_in_memory'
1916 70BD              ;               dc      i2'load_file_length'
1917 70BD
1918 70BD 48                    pha                            ;save segment ID type
1919 70BE 8E 08 7D              stx   |load_file_len           ;save for iload
1920 70C1
1921 70C1 AD EA 7C              lda   |buf_ptr
1922 70C4 8D 04 7D              sta   |load_file_adr           ;low word of where in memory it is
1923 70C7 AD EC 7C              lda   |buf_ptr+2
1924 70CA 8D 06 7D              sta   |load_file_adr+2         ;high word of where in memory it is
1925 70CD
1926 70CD              ; set up registers for special iload call as follows
1927 70CD              ;               y = high word of address to table containing special iload info
1928 70CD              ;               x = low word of address to table containing special iload info
1929 70CD
1930 70CD A9 02 00              lda   #2
1931 70D0 8D F4 7C              sta   |iload_type              ;do initial load from memory
1932 70D3 A0 00 00              ldy   #load_file_adr>>16       ;hi word of table address
1933 70D6 A2 04 7D              ldx   #load_file_adr           ;lo word of table address
1934 70D9 68                    pla                            ;retrieve segment ID type
1935 70DA 20 DE 70              jsr   iload_file               ;do the initial load
1936 70DD 60                    rts   
1937 70DE
1938 70DE                       ENDP 
1939 70DE
1940 70DE
1941 70DE
1942 70DE                       eject 
1943 70DE              ;===============================================================================
1944 70DE              ; iload_file
1945 70DE              ;
1946 70DE              ; Entry is in 16-bit native mode.
1947 70DE              ; Exit is in 16-bit native mode.
1948 70DE              ; Data bank register is set to bank $00 on entry and exit.
1949 70DE              ;
1950 70DE              ; Inputs:       X - low word of pathname address or table address
1951 70DE              ;               Y - high word of pathname address or table address
1952 70DE              ;               A - segment ID type  (Main field should be zero)
1953 70DE              ;
1954 70DE              ; Outputs:      c - 0 if no error ; 1 if error
1955 70DE              ;               A - error code if c=1
1956 70DE              ;               load_adr - 4 byte starting address of the loaded file
1957 70DE              ;               e1_user_id - user ID of the file loaded
1958 70DE              ;               e1_zp_start - starting address of the zero page segment
1959 70DE              ;               e1_zp_size - size in bytes of the zero page segment
1960 70DE              ;
1961 70DE              ; This routine first calls the ID manager for a unique ID given an ID type.
1962 70DE              ; The returned ID is then used in the InitialLoad2 call for the file.
1963 70DE              ; All outputs from the load call are returned in the above named variables.
1964 70DE              ; This routine is intended to load only setup files, DA files, FST files,
1965 70DE              ; and the custom boot driver file so they will NEVER be loaded into special memory!
1966 70DE              ;===============================================================================
1967 70DE
1968 70DE              iload_file PROC 
1969 70DE
1970 70DE                       longa on
1971 70DE                       longi on
1972 70DE
1973 70DE DA                    phx                            ; Save pathname or table address
1974 70DF 5A                    phy   
1975 70E0
1976 70E0 48                    pha                            ; Push space for result
1977 70E1 48                    pha                            ; segment ID type
1978 70E2 A2 03 20 22           _getnewid                      ; get a unique user ID
1979 70E9 90 04                 bcc   ok
1980 70EB FA                    plx                            ; clean up stack
1981 70EC FA                    plx   
1982 70ED FA                    plx   
1983 70EE 60                    rts                            ; Return with c set by call, error in A.
1984 70EF
1985 70EF              ok        
1986 70EF 68                    pla                            ; get the new user ID
1987 70F0 7A                    ply                            ; Retrieve pathname or table address
1988 70F1 FA                    plx   
1989 70F2
1990 70F2 48                    pha                            ; Push 10 bytes for result space
1991 70F3 48                    pha   
1992 70F4 48                    pha   
1993 70F5 48                    pha   
1994 70F6 48                    pha   
1995 70F7 48                    pha                            ; Push user ID
1996 70F8 5A                    phy                            ; Push hi word of pathname or table adrs
1997 70F9 DA                    phx                            ; Push lo word of pathname or table adrs
1998 70FA F4 01 00              pea   1                        ; File cannot load into special mem.
1999 70FD AD F4 7C              lda   |iload_type              ; Push load type info
2000 7100 48                    pha   
2001 7101 A2 11 20 22           _initialload2                  ; Load the file
2002 7108 A8                    tay                            ; save error code
2003 7109 68                    pla                            ; Pull user id
2004 710A 8F 77 D6 E1           sta   >e1_user_id
2005 710E 68                    pla                            ; Get low adrs of program entry
2006 710F 8D F6 7C              sta   |load_adr
2007 7112 68                    pla                            ; Get hi adrs of entry
2008 7113 8D F8 7C              sta   |load_adr+2
2009 7116 68                    pla                            ; Pull zero page buffer address.
2010 7117 8F 9B D6 E1           sta   >e1_zp_start
2011 711B 68                    pla                            ; Pull size of buffer.
2012 711C 8F 9D D6 E1           sta   >e1_zp_size
2013 7120 98                    tya                            ; restore error code
2014 7121 60                    rts                            ; Return with c set by call, error in A.
2015 7122                       ENDP 
2016 7122
2017 7122
2018 7122
2019 7122                       eject 
2020 7122              ;===============================================================================
2021 7122              ; unload_file
2022 7122              ;
2023 7122              ; Entry is in 16-bit native mode.
2024 7122              ; Exit is in 16-bit native mode.
2025 7122              ; Data bank register is set to bank $00 on entry and exit.
2026 7122              ;
2027 7122              ; Inputs:       e1_user_id - User ID to shut down
2028 7122              ;
2029 7122              ; Outputs:      A - error code if c=1
2030 7122              ;               c - 0 if no error, 1 if error
2031 7122              ;
2032 7122              ; Calls the system loader's UserShutDown call to unload a file.
2033 7122              ;===============================================================================
2034 7122
2035 7122              unload_file PROC 
2036 7122                       longa on
2037 7122                       longi on
2038 7122
2039 7122 48                    pha                            ; Stack space for ID result.
2040 7123 AF 77 D6 E1           lda   >e1_user_id
2041 7127 48                    pha                            ; Push input ID.
2042 7128 F4 00 00              pea   0                        ; Push input Flags.
2043 712B A2 11 12 22           _usershutdown 
2044 7132 FA                    plx                            ; ignore return ID.
2045 7133 60                    rts   
2046 7134                       ENDP 
2047 7134
2048 7134
2049 7134
2050 7134                       eject 
2051 7134              ;===============================================================================
2052 7134              ; find_sys_file
2053 7134              ;
2054 7134              ; Entry is in 16-bit native mode.
2055 7134              ; Exit is in 16-bit native mode.
2056 7134              ; Data bank register is set to bank $00 on entry and exit.
2057 7134              ;
2058 7134              ; Inputs:       none
2059 7134              ;
2060 7134              ; Outputs:      c - 0 if no error ; 1 if        error.
2061 7134              ;               A - error code if c=1
2062 7134              ;
2063 7134              ; This routine will look for the first file in the volume directory that has
2064 7134              ; filetype $B3 (S16) and whose name ends with '.SYS16' OR that has filetype
2065 7134              ; $FF (SYS) and whose name ends with '.SYSTEM'.
2066 7134              ; If '*/SYSTEM/P8' does not exist then it will only look for S16 files.
2067 7134              ; If a valid file is found, its name is copied into 'e1_sys_filename' as a
2068 7134              ; class 0 string.
2069 7134              ;===============================================================================
2070 7134
2071 7134              find_sys_file PROC 
2072 7134                       DataChk off
2073 7134
2074 7134                       longa on
2075 7134                       longi on
2076 7134
2077 7134              ; first, check to see if P8 exists
2078 7134
2079 7134 A9 01 D9              lda   #e1_p8_path              ;set up parameters for call
2080 7137 8F D3 D5 E1           sta   >e1_gfi_ptr
2081 713B A9 E1 00              lda   #e1_p8_path>>16
2082 713E 8F D5 D5 E1           sta   >e1_gfi_ptr+2
2083 7142 22 A8 00 E1           _getfileinfo1 e1_gfi_parms1 
2084 714C B0 03                 bcs   nop8
2085 714E EE D6 7C              inc   |gotp8                   ;indicate that P8 exists
2086 7151              nop8      
2087 7151
2088 7151              ; now, copy the pathname '*/' into pathname buffer
2089 7151
2090 7151 A2 E5 7F              ldx   #vol_path                ; get address of string
2091 7154 20 FD 71              jsr   copy_to_buf
2092 7157
2093 7157              ; open the volume directory
2094 7157
2095 7157 22 A8 00 E1           _open1 open_parms1             ; open the volume directory
2096 7161 B0 78                 bcs   start_err2
2097 7163
2098 7163 AD 84 7C              lda   |open_ref                ; copy reference number into
2099 7166 8D 92 7C              sta   |gde_ref                 ; getdirentry parameter list
2100 7169 8D 8E 7C              sta   |close_ref               ; and close parameter list
2101 716C
2102 716C              ; initialize the directory entry index to 0
2103 716C
2104 716C 9C 98 7C              stz   |gde_disp
2105 716F
2106 716F              ; loop through the directory entries to find the first .system or .sys16 file
2107 716F
2108 716F              check_entry  
2109 716F EE 98 7C              inc   |gde_disp                ;increment entry index
2110 7172 22 A8 00 E1           _getdirentry1 gde_parms1       ;get the next directory entry
2111 717C B0 4D                 bcs   start_err
2112 717E AD A0 7C              lda   |gde_filetype            ;get the entry's filetype
2113 7181 A2 48 7F              ldx   #s16name                 ;address of string
2114 7184 C9 B3 00              cmp   #s16_ftype               ;is it a .sys16 file?
2115 7187 F0 0D                 beq   check_name               ;yes
2116 7189 AE D6 7C              ldx   |gotp8                   ;does P8 exist?
2117 718C F0 E1                 beq   check_entry              ;no - so can't run a SYS file
2118 718E A2 40 7F              ldx   #sysname                 ;address of string
2119 7191 C9 FF 00              cmp   #sys_ftype               ;is it a .system file?
2120 7194 D0 D9                 bne   check_entry              ;no - so check next entry
2121 7196              check_name  
2122 7196 DA                    phx                            ;push address of string to match
2123 7197 A0 00 00              ldy   #0
2124 719A B3 01                 lda   (1,s),y                  ;get length of string to match
2125 719C 29 FF 00              and   #$00ff                   ;mask off hi byte
2126 719F A8                    tay   
2127 71A0 CD 0C 7D              cmp   |filename                ;is filename > string to match?
2128 71A3 B0 21                 bcs   no_match                 ;no - so not a start file
2129 71A5 AE 0C 7D              ldx   |filename                ;get length word of filename
2130 71A8 E8                    inx                            ;add 1 for extra length byte
2131 71A9
2132 71A9 E2 30                 sep   #$30                     ;***** begin 8-bit mode
2133 71AB                       longa off
2134 71AB                       longi off
2135 71AB              name_loop                               ;compare strings from end
2136 71AB BD 0C 7D              lda   |filename,x              ;get character from filename
2137 71AE C9 61                 cmp   #'a'                     ;convert to upper case
2138 71B0 90 07                 bcc   cvt_done
2139 71B2 C9 7B                 cmp   #'{'
2140 71B4 B0 03                 bcs   cvt_done
2141 71B6 38                    sec   
2142 71B7 E9 20                 sbc   #$20
2143 71B9              cvt_done  
2144 71B9 D3 01                 cmp   (1,s),y                  ;compare to test string
2145 71BB D0 09                 bne   no_match                 ;found a mismatch
2146 71BD CA                    dex   
2147 71BE 88                    dey   
2148 71BF D0 EA                 bne   name_loop
2149 71C1
2150 71C1 C2 30                 rep   #$30                     ;***** return to 16-bit mode
2151 71C3                       longa on
2152 71C3                       longi on
2153 71C3
2154 71C3 68                    pla                            ;clean up stack
2155 71C4 80 16                 bra   found_it                 ;the strings match
2156 71C6
2157 71C6              no_match  
2158 71C6 C2 30                 rep   #$30                     ;***** return to 16-bit mode
2159 71C8                       longa on
2160 71C8                       longi on
2161 71C8
2162 71C8 68                    pla                            ;clean up stack
2163 71C9 80 A4                 bra   check_entry              ;no match so check next entry
2164 71CB
2165 71CB              ; got an error searching for a .system or .sys16 file
2166 71CB
2167 71CB              start_err  
2168 71CB 48                    pha                            ; save error code
2169 71CC 22 A8 00 E1           _close1 close_parms1           ; close the directory.
2170 71D6 FA                    plx                            ; retrieve error code
2171 71D7 B0 02                 bcs   start_err2               ; got an error from Close call
2172 71D9 38                    sec                            ; indicate error
2173 71DA 8A                    txa                            ; put original error code back in A
2174 71DB              start_err2  
2175 71DB 60                    rts   
2176 71DC
2177 71DC              ; a .sys16 or .system file entry was found so copy filename into data area
2178 71DC              ; and save the filetype
2179 71DC
2180 71DC              found_it  
2181 71DC AE 0C 7D              ldx   |filename                ;get length word of filename
2182 71DF              copy_loop  
2183 71DF BD 0C 7D              lda   |filename,x              ;copy filename into local data area
2184 71E2 9F DF D8 E1           sta   >e1_sys_filename,x       ;as a class 1 string
2185 71E6 CA                    dex   
2186 71E7 10 F6                 bpl   copy_loop
2187 71E9 AF DF D8 E1           lda   >e1_sys_filename         ;get name length word
2188 71ED 1A                    inc   a                        ;add 1 for leading colon
2189 71EE 09 00 3A              ora   #$3A00                   ;add leading colon & convert to class 0
2190 71F1 8F DF D8 E1           sta   >e1_sys_filename         ;string
2191 71F5
2192 71F5 AD A0 7C              lda   |gde_filetype            ;get the filetype again
2193 71F8 8D DC 7C              sta   |save_filetype           ;save for later
2194 71FB
2195 71FB 18                    clc                            ;indicate no error
2196 71FC 60                    rts   
2197 71FD
2198 71FD                       DataChk on
2199 71FD                       ENDP 
2200 71FD
2201 71FD
2202 71FD
2203 71FD                       eject 
2204 71FD              ;===============================================================================
2205 71FD              ; copy_to_buf
2206 71FD              ;
2207 71FD              ; Entry is in 16-bit native mode.
2208 71FD              ; Exit is in 16-bit native mode.
2209 71FD              ; Data bank register is set to bank $00 on entry and exit
2210 71FD              ;
2211 71FD              ; Inputs:       X - contains low word of string address
2212 71FD              ;
2213 71FD              ; Outputs:      path_buf - contains a copy of the string
2214 71FD              ;
2215 71FD              ; This routine copies a string into path_buf.
2216 71FD              ; The string must be class 1 format and must be in bank $00.
2217 71FD              ;===============================================================================
2218 71FD
2219 71FD              copy_to_buf PROC 
2220 71FD
2221 71FD                       longa on
2222 71FD                       longi on
2223 71FD
2224 71FD DA                    phx                            ;push string address on stack
2225 71FE A0 00 00              ldy   #0
2226 7201
2227 7201 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
2228 7203                       longa off
2229 7203                       longi off
2230 7203
2231 7203 B3 01                 lda   (1,s),y                  ;get length of string
2232 7205 A8                    tay   
2233 7206 C8                    iny                            ;add 1 since it's a class 1 string
2234 7207
2235 7207              loop      
2236 7207 B3 01                 lda   (1,s),y                  ;copy string into path_buf
2237 7209 99 2E 7D              sta   |path_buf,y
2238 720C 88                    dey   
2239 720D 10 F8                 bpl   loop
2240 720F
2241 720F C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
2242 7211                       longa on
2243 7211                       longi on
2244 7211
2245 7211 FA                    plx                            ;clean up stack
2246 7212 60                    rts   
2247 7213                       ENDP 
2248 7213
2249 7213
2250 7213
2251 7213                       eject 
2252 7213              ;===============================================================================
2253 7213              ; make_full_path
2254 7213              ;
2255 7213              ; Entry is in 16-bit native mode.
2256 7213              ; Exit is in 16-bit native mode.
2257 7213              ; Data bank register is set to bank $00 on entry and exit
2258 7213              ;
2259 7213              ; Inputs:       path_buf - contains a partial pathname (class 1)
2260 7213              ;               path_len - contains the length word of the partial pathname
2261 7213              ;               filename - contains a filename (class 1)
2262 7213              ;
2263 7213              ; Outputs:      path_buf - contains a full pathname (class 1)
2264 7213              ;
2265 7213              ; This routine creates a full pathname (class 1) by appending the filename
2266 7213              ; contained in filename onto the partial pathname contained in path_buf.
2267 7213              ;===============================================================================
2268 7213
2269 7213              make_full_path PROC 
2270 7213
2271 7213                       longa on
2272 7213                       longi on
2273 7213
2274 7213 AD F2 7C              lda   |path_len                ;get length of partial path
2275 7216 8D 2E 7D              sta   |path_buf                ;and store
2276 7219
2277 7219 F4 01 00              pea   1                        ; indicate class 1 strings
2278 721C F4 00 00              pea   path_buf>>16             ; Push ptr to string1
2279 721F F4 2E 7D              pea   path_buf
2280 7222 F4 00 00              pea   filename>>16             ; Push ptr to string2
2281 7225 F4 0C 7D              pea   filename
2282 7228 F4 00 00              pea   path_buf>>16             ; Push ptr to resultant string
2283 722B F4 2E 7D              pea   path_buf
2284 722E 22 AB D2 E1           jsl   concat                   ; create full pathname
2285 7232
2286 7232 60                    rts   
2287 7233                       ENDP 
2288 7233
2289 7233
2290 7233
2291 7233                       eject 
2292 7233              ;===============================================================================
2293 7233              ; relocate_segs
2294 7233              ;
2295 7233              ; Enter:           jsr
2296 7233              ;
2297 7233              ; Input:           A = undefined
2298 7233              ;                  X = undefined
2299 7233              ;                  Y = undefined
2300 7233              ;                  P = nvmxdizc
2301 7233              ;                      ..000...        <- '.' = undefined
2302 7233              ;               mode = native
2303 7233              ;                  b = k
2304 7233              ;             LCBank = undefined
2305 7233              ;
2306 7233              ; Output:          A = undefined
2307 7233              ;                  X = undefined
2308 7233              ;                  Y = undefined
2309 7233              ;                  P = nvmxdizc
2310 7233              ;                      ..000...        <- '.' = undefined
2311 7233              ;               mode = native
2312 7233              ;                  b = k
2313 7233              ;             LCBank = undefined
2314 7233              ;
2315 7233              ; Input Stack Parameters:  none
2316 7233              ;
2317 7233              ; Output Stack Parameters: none
2318 7233              ;
2319 7233              ;
2320 7233              ; This routine will utilize the header/code segment commands at the beginning
2321 7233              ; of each file segment to relocate the segments to the correct place.
2322 7233              ;
2323 7233              ; The header for all binary files which are to be appended to gs.os is:
2324 7233              ;
2325 7233              ;               dc      i2'xxxx_len'    ;number of bytes to load in
2326 7233              ;               dc      i4'xxxx_dest'   ;address where the segment goes
2327 7233              ;               dc      i2'xxxx_flag'   ;flag byte (explained shortly)
2328 7233              ;               dc      c'this code. ver# 0.02' ;any text string (msb on)
2329 7233              ;
2330 7233              ;               flag -  bit 15   = 0/1 swap in language card bank 0/1
2331 7233              ;                       bit 14-1 = reserved and must be set to zero
2332 7233              ;                       bit 0    = 0/1 call sys loader to relocate start FST
2333 7233              ;
2334 7233              ; The code segment follows this header information.
2335 7233              ;
2336 7233              ; Following the last set of header/code segments is a $ffff word.
2337 7233              ; This signifies the end of the table.
2338 7233              ;===============================================================================
2339 7233
2340 7233              relocate_segs PROC 
2341 7233
2342 7233                       longa on
2343 7233                       longi on
2344 7233
2345 7233              gs_os_pointer equ   1
2346 7233
2347 7233 0B                    phd                            ;save direct register
2348 7234 AD EC 7C              lda   |buf_ptr+2               ;push mem buf pointer on stack
2349 7237 48                    pha   
2350 7238 AD EA 7C              lda   |buf_ptr
2351 723B 48                    pha   
2352 723C 3B                    tsc   
2353 723D 5B                    tcd                            ;set direct register to stack
2354 723E
2355 723E              ;test if last segment already moved before proceeding
2356 723E
2357 723E              move_loop  
2358 723E A0 00 00              ldy   #hdr_code_len            ;test for $ffff terminator
2359 7241 B7 01                 lda   [<gs_os_pointer],y
2360 7243 1A                    inc   a                        ;increments to $0000 when done
2361 7244 D0 0E                 bne   move_seg1                ;<>= then more to move
2362 7246 E2 20                 sep   #$20                     ;switch to 8 bit mode to hit softswitch
2363 7248 AD 8B C0              lda   lcbank1                  ;switch in language card bank 0
2364 724B AD 8B C0              lda   lcbank1                  ;and write enable it
2365 724E C2 20                 rep   #$20                     ;back to 16-bit mode
2366 7250 68                    pla                            ;clean up stack
2367 7251 68                    pla   
2368 7252 2B                    pld                            ;restore direct register
2369 7253 60                    rts                            ;back to caller since we're done
2370 7254
2371 7254              move_seg1  
2372 7254 AD F0 7C              lda   |text_flag               ;should we put up the header message?
2373 7257 F0 10                 beq   skip_msg                 ;no
2374 7259
2375 7259 18                    clc   
2376 725A A5 01                 lda   <gs_os_pointer           ;calculate address of message
2377 725C 69 08 00              adc   #hdr_msg
2378 725F AA                    tax   
2379 7260 A5 03                 lda   <gs_os_pointer+2
2380 7262 69 00 00              adc   #0
2381 7265 A8                    tay   
2382 7266 20 C3 72              jsr   print_message            ;print the message
2383 7269              skip_msg  
2384 7269
2385 7269 18                    clc                            ;prepare to add
2386 726A A9 30 00              lda   #gs_os_hdr_len           ;calculate where the code starts
2387 726D 65 01                 adc   <gs_os_pointer
2388 726F AA                    tax                            ;save in x til high word is calculated
2389 7270 A4 03                 ldy   <gs_os_pointer+2         ;high word of pointer to gs.os
2390 7272 90 01                 bcc   move_seg4                ;'c'=0 then no carry
2391 7274 C8                    iny                            ;'c'=1 then must add carry
2392 7275              move_seg4  
2393 7275 5A                    phy                            ;source address high word for move
2394 7276 DA                    phx                            ;source address low word for move
2395 7277 A0 04 00              ldy   #hdr_code_dest+2         ;offset to high word of destination adr
2396 727A B7 01                 lda   [<gs_os_pointer],y
2397 727C 48                    pha                            ;destination address high word for move
2398 727D 88                    dey                            ;get to low word of destination address
2399 727E 88                    dey   
2400 727F B7 01                 lda   [<gs_os_pointer],y
2401 7281 48                    pha                            ;destination address low word for move
2402 7282 F4 00 00              pea   $0000                    ;high word of count to move always=$0000
2403 7285 A0 00 00              ldy   #hdr_code_len            ;offset to code length low word
2404 7288 B7 01                 lda   [<gs_os_pointer],y
2405 728A 48                    pha                            ;code length low word
2406 728B A0 06 00              ldy   #hdr_lc_flag             ;offset to language card flag
2407 728E B7 01                 lda   [<gs_os_pointer],y       ;'-' if second language card bank
2408 7290 0A                    asl   a                        ;save status in carry
2409 7291 E2 20                 sep   #$20                     ;switch to 8 bit mode to hit softswitch
2410 7293 AD 8B C0              lda   lcbank1                  ;assume first language card bank
2411 7296 AD 8B C0              lda   lcbank1                  ;assume first language card bank
2412 7299 90 06                 bcc   lcbank_setup             ;'c'=0 then we're done with lang card
2413 729B AD 83 C0              lda   lcbank2                  ;code requires second language card bank
2414 729E AD 83 C0              lda   lcbank2                  ;code requires second language card bank
2415 72A1              lcbank_setup  
2416 72A1 C2 20                 rep   #$20                     ;back to normal mode
2417 72A3 20 B7 82              jsr   moveblock                ;move the code to correct memory area
2418 72A6
2419 72A6              ;now move gs_os_pointer to point to the next segment in memory
2420 72A6
2421 72A6 18                    clc                            ;prepare to add
2422 72A7 A0 00 00              ldy   #hdr_code_len            ;add code len+hdr len+ptr for next hdr
2423 72AA B7 01                 lda   [<gs_os_pointer],y       ;code length is 1 word in len only!!!
2424 72AC 65 01                 adc   <gs_os_pointer           ;low word of pointer
2425 72AE 85 01                 sta   <gs_os_pointer           ;save new pointer
2426 72B0 90 02                 bcc   update_ptr_don1
2427 72B2 E6 03                 inc   <gs_os_pointer+2         ;add 1 if carry was set
2428 72B4              update_ptr_don1  
2429 72B4 18                    clc                            ;prepare to add
2430 72B5 A5 01                 lda   <gs_os_pointer           ;low word of pointer
2431 72B7 69 30 00              adc   #gs_os_hdr_len           ;low word of header length (high word=0)
2432 72BA 85 01                 sta   <gs_os_pointer           ;save new pointer
2433 72BC 90 02                 bcc   update_ptr_don2
2434 72BE E6 03                 inc   <gs_os_pointer+2         ;add 1 if carry was set
2435 72C0              update_ptr_don2  
2436 72C0 4C 3E 72              jmp   move_loop                ;loop til terminator is found
2437 72C3                       ENDP 
2438 72C3
2439 72C3
2440 72C3
2441 72C3                       eject 
2442 72C3              ;===============================================================================
2443 72C3              ; print_message
2444 72C3              ;
2445 72C3              ; Entry is in 16-bit native mode.
2446 72C3              ; Exit is in 16-bit native mode.
2447 72C3              ; Data bank register is set to bank $00 on entry and exit.
2448 72C3              ; Direct register is preserved.
2449 72C3              ;
2450 72C3              ; Inputs:       X = low word of address of first character of message
2451 72C3              ;               Y = high word of address of first character of message
2452 72C3              ;
2453 72C3              ; Outputs:      none
2454 72C3              ;
2455 72C3              ; Prints out a message.
2456 72C3              ; X and Y must contain the address of the first character of the message.
2457 72C3              ; The message must end with a null ($00).
2458 72C3              ;===============================================================================
2459 72C3
2460 72C3              print_message PROC 
2461 72C3
2462 72C3              msg_ptr  equ   1
2463 72C3
2464 72C3                       longa on
2465 72C3                       longi on
2466 72C3
2467 72C3              ;if a key hasn't been pressed don't waste time displaying messages
2468 72C3
2469 72C3 E2 20                 sep   #$20                     ;8 bit 'm' to test key
2470 72C5 AD 00 C0              lda   kbd                      ;'-' if key is pressed
2471 72C8 10 28                 bpl   nokeynomessage           ;'+' so skip printing message
2472 72CA
2473 72CA              ;a key has been pressed
2474 72CA
2475 72CA C2 20                 rep   #$20                     ;return to 16-bit m
2476 72CC
2477 72CC 0B                    phd                            ;save direct page on stack
2478 72CD 5A                    phy                            ;push address of message on stack
2479 72CE DA                    phx   
2480 72CF 3B                    tsc   
2481 72D0 5B                    tcd                            ;set direct reg to point to stack
2482 72D1
2483 72D1 A0 00 00              ldy   #$0000                   ;start at first byte to display
2484 72D4
2485 72D4 B7 01        loop     lda   [<msg_ptr],y             ;pick up a character to display
2486 72D6 29 FF 00              and   #$00ff
2487 72D9 F0 0E                 beq   done                     ;$00 is terminator
2488 72DB 09 80 00              ora   #$0080                   ;set high bit in case someone forgot!!!
2489 72DE 5A                    phy                            ;save Y
2490 72DF A2 ED FD              ldx   #cout
2491 72E2 20 F5 72              jsr   call_fw                  ;output the character
2492 72E5
2493 72E5 7A                    ply                            ;restore Y
2494 72E6 C8                    iny                            ;next character please
2495 72E7 80 EB                 bra   loop                     ;fall out
2496 72E9
2497 72E9              done      
2498 72E9 A2 8E FD              ldx   #crout                   ;always go to next line when done
2499 72EC 20 F5 72              jsr   call_fw
2500 72EF
2501 72EF 68                    pla                            ;clean up stack
2502 72F0 68                    pla   
2503 72F1 2B                    pld                            ;restore direct page
2504 72F2
2505 72F2              ;branch here if not printing
2506 72F2
2507 72F2              nokeynomessage  
2508 72F2 C2 20                 rep   #$20                     ;return to 16-bit m
2509 72F4 60                    rts                            ;back to caller
2510 72F5
2511 72F5              ;------------------------------------------------------------------------------
2512 72F5
2513 72F5                       EXPORT  call_fw
2514 72F5              call_fw   
2515 72F5 48                    pha                            ;push space for result
2516 72F6 48                    pha   
2517 72F7 48                    pha   
2518 72F8 48                    pha   
2519 72F9 48                    pha                            ;push A
2520 72FA DA                    phx                            ;push X
2521 72FB 5A                    phy                            ;push Y
2522 72FC DA                    phx                            ;address of routine to call
2523 72FD A2 03 24 22           _FWEntry 
2524 7304 68                    pla                            ;ignore results
2525 7305 68                    pla   
2526 7306 68                    pla   
2527 7307 68                    pla   
2528 7308 60                    rts   
2529 7309
2530 7309                       ENDP 
2531 7309
2532 7309
2533 7309
2534 7309                       eject 
2535 7309              ;===========================================================================
2536 7309              ; 'Big Splash' by:
2537 7309              ;
2538 7309              ;                Rob Turner
2539 7309              ;                   and
2540 7309              ;               Bryan Atsatt
2541 7309              ;                   and
2542 7309              ;              Steven E. Glass
2543 7309              ;
2544 7309              ;Entry points:
2545 7309              ;
2546 7309              ; splash_screen:        input A = total time
2547 7309              ; restart_heartbeat:    input none
2548 7309              ; boot_complete:        input none
2549 7309              ; stop_progress:        input none
2550 7309              ;
2551 7309              ;
2552 7309              ; Change History
2553 7309              ;
2554 7309              ; 27 Jul 88      Steven Glass
2555 7309              ;
2556 7309              ; No longer changes the border color.  Instead uses the border color as
2557 7309              ; the background color.
2558 7309              ;
2559 7309              ; 11 Nov 88     Rob Turner
2560 7309              ;
2561 7309              ;               Added Stop_Splash routine.  GLoader calls this routine if
2562 7309              ;               it is switching to ProDOS8.
2563 7309              ;
2564 7309              ; 30 Nov 88     Rob Turner
2565 7309              ;
2566 7309              ;               Fixed linear bit problem when switching to text mode.  Now
2567 7309              ;               When we switch to text we disable linear mode, then when we
2568 7309              ;               switch to graphics mode I turn on the linear bit.
2569 7309              ;
2570 7309              ; 06 Dec 88     Rob Turner
2571 7309              ;
2572 7309              ;               Fixed a bug with the fill routine.  If text mode was enabled
2573 7309              ;               Then linear bit was wrong
2574 7309              ;
2575 7309              ; 23 Sep 90     Greg Branche
2576 7309              ;               Moved "Welcome…" text up and added second text string
2577 7309              ;               to display system disk version number.
2578 7309              ;===========================================================================
2579 7309
2580 7309
2581 7309
2582 7309              *******************************************************************************
2583 7309              *
2584 7309              * Equates...
2585 7309              *
2586 7309
2587 7309                       longa on
2588 7309                       longi on
2589 7309
2590 7309              splash_screen PROC 
2591 7309
2592 7309              line     equ   $A0                      ;number of bytes per scan line
2593 7309
2594 7309              display_buffer equ   $e12000
2595 7309              display_buf_end equ   $e1a000
2596 7309              buf_len  equ   display_buf_end-display_buffer
2597 7309
2598 7309              graph_chk_loc PointAddress 58,148       ;contains a $00F0
2599 7309              graph_chk_val equ   $00F0
2600 7309              scan_control equ   $e19d00
2601 7309              color_palette equ   $e19e00
2602 7309              box_start PointAddress 57,148 
2603 7309              icon_start PointAddress 62,176 
2604 7309              progress_start PointAddress 88,292 
2605 7309              prog_draw_start PointAddress 89,292 
2606 7309              border_register equ   $e1c034
2607 7309              pascal_cursor equ   $E10400             ;check for pascal cursor
2608 7309              screen_test equ   $E007F7               ;check for pascal char
2609 7309              screen_char equ   $E5                   ;a normal 'e'
2610 7309              space    equ   $A0                      ;a normal ' '
2611 7309
2612 7309              display_switch equ   $c029
2613 7309              graphics_mode equ   $80
2614 7309              linear_mode equ   $40
2615 7309              keyboard equ   $C000
2616 7309              keyboard_strobe equ   $C010
2617 7309
2618 7309              screen_ptr equ   $00
2619 7309              icon_ptr equ   $04
2620 7309              retry_delay equ   180                   ;wait three seconds
2621 7309              text_Count equ   25
2622 7309              no_screen equ   'RT'
2623 7309              our_special_color equ $DDDD             ; fill to finder desktop pattern.
2624 7309
2625 7309
2626 7309 08                    php                            ;save m and x bits
2627 730A 8B                    phb                            ;save caller's bank register
2628 730B
2629 730B 4B                    phk   
2630 730C AB                    plb                            ;set data bank to our bank please
2631 730D
2632 730D C2 30                 rep   #$30
2633 730F 9C 4A 77              stz   armed                    ;we are not armed yet
2634 7312
2635 7312 C9 00 00              cmp   #$0000                   ;time for this boot
2636 7315 D0 01                 bne   good_time
2637 7317 1A                    inc   a                        ;minimum is one!!!
2638 7318
2639 7318              good_time  
2640 7318 C9 54 52              cmp   #no_screen               ;do not display anything
2641 731B F0 11                 beq   no_show
2642 731D
2643 731D 8D 3C 77              sta   our_counter              ;internal tick counter timer
2644 7320 8D 3E 77              sta   local_counter
2645 7323 9C 52 77              stz   heart_active             ;are we running
2646 7326
2647 7326                       longa off
2648 7326 E2 20                 sep   #$20
2649 7328 AF 00 C0 00           lda   >keyboard                ;should we start?
2650 732C 10 08                 bpl   do_startup               ;we want to run
2651 732E
2652 732E              no_show   
2653 732E                       longa on
2654 732E C2 20                 rep   #$20
2655 7330 8D 52 77              sta   heart_active
2656 7333 4C A5 73              jmp   abort
2657 7336
2658 7336              do_startup  
2659 7336
2660 7336 C2 20                 rep   #$20
2661 7338                       longa on
2662 7338
2663 7338 A9 00 00              lda   #$0000
2664 733B 8D 5E 77              sta   new_time
2665 733E 8D 46 77              sta   progress_complete        ;file has not been updated. (Default)
2666 7341 8D 4C 77              sta   app_armed
2667 7344 1A                    inc   a
2668 7345 8D 48 77              sta   task_time                ;task timer for heartbeat task
2669 7348
2670 7348 F4 E1 20              pea   $20E1                    ;switch data bank to graphics memory and set 8-bit accumulator
2671 734B AB                    plb   
2672 734C 28                    plp   
2673 734D                       longa off
2674 734D
2675 734D              *
2676 734D              * Set display area to linear mode...
2677 734D              *
2678 734D A9 40                 lda   #linear_mode             ;Make sure we are in text/linear mode.
2679 734F 0C 29 C0              tsb   display_switch
2680 7352                       longa on
2681 7352 C2 20                 rep   #$20
2682 7354
2683 7354              *
2684 7354              * Clear screen to "desktop blue" and init scan-line control bytes and color palettes...
2685 7354              *
2686 7354 A9 DD DD              lda   #our_special_color       ;get the color pattern
2687 7357 8F 00 20 E1           sta   display_buffer           ;and store in first word of display buffer
2688 735B A2 00 20              ldx   #display_buffer AND $FFFF ;move from first byte of display buffer
2689 735E A0 02 20              ldy   #(display_buffer AND $FFFF)+2 ;to third byte of display buffer
2690 7361 A9 FD 7F              lda   #buf_len-3               ;for entire buffer (filling buffer with color pattern)
2691 7364 8B                    phb                            ;save DBR
2692 7365 54 E1 E1              mvn   display_buffer,display_buffer
2693 7368 AB                    plb                            ;restore DBR
2694 7369
2695 7369              *
2696 7369              * Set all scan-line control bytes to 640 mode...
2697 7369              *
2698 7369 A2 FE 00              ldx   #$00fe
2699 736C A9 80 80              lda   #$8080
2700 736F 9F 00 9D E1  scb_loop sta   scan_control,x
2701 7373 CA                    dex   
2702 7374 CA                    dex   
2703 7375 10 F8                 bpl   scb_loop
2704 7377
2705 7377
2706 7377              *
2707 7377              * Fill in color palette...
2708 7377              *
2709 7377 A2 0E 00              ldx   #$000e
2710 737A BF 78 77 00  palette_loop lda   >palette,x
2711 737E 9F 00 9E E1           sta   color_palette,x
2712 7382 9F 10 9E E1           sta   color_palette+$10,x
2713 7386 CA                    dex   
2714 7387 CA                    dex   
2715 7388 10 F0                 bpl   palette_loop
2716 738A              *
2717 738A              * Turn on graphics display and exit...
2718 738A              *
2719 738A                       longa on
2720 738A C2 20                 rep   #$20
2721 738C 64 06                 stz   icon_ptr+2               ;data for icon and text is ALWAYS in bank 0
2722 738E A9 E1 00              lda   #$00E1                   ;and ALWAYS get's written to bank $E1
2723 7391 85 02                 sta   screen_ptr+2
2724 7393 20 F4 75              jsr   draw_box                 ;draw the standard white box
2725 7396 20 0E 76              jsr   draw_icon                ;draw the IIGS Icon
2726 7399 20 2D 76              jsr   draw_text                ;draw 'Welcome the IIGS'
2727 739C 20 BB 76              jsr   draw_progress            ;draw the progress bar please
2728 739F
2729 739F 20 96 74              jsr   graphics_on
2730 73A2 20 0C 74              jsr   start_heartbeat          ;start the draw progress
2731 73A5
2732 73A5              abort     
2733 73A5 AB                    plb                            ;restore caller's bank and status reg
2734 73A6 28                    plp   
2735 73A7 60                    rts   
2736 73A8
2737 73A8              ;=============================================================================
2738 73A8              ;start_scrn_chk This routine will start the screen monitor code.
2739 73A8              ;               It will also turn on the graphics display
2740 73A8              ;=============================================================================
2741 73A8                       EXPORT start_scrn_chk
2742 73A8              start_scrn_chk  
2743 73A8 8B                    phb                            ;save data bank register
2744 73A9
2745 73A9 4B                    phk   
2746 73AA AB                    plb   
2747 73AB
2748 73AB 08                    php   
2749 73AC 78                    sei   
2750 73AD                       longa on
2751 73AD                       longi on
2752 73AD C2 30                 rep   #$30
2753 73AF AD 4C 77              lda   app_armed                ;have we decided to stop already?
2754 73B2 30 15                 bmi   start_exit
2755 73B4
2756 73B4 AD 52 77              lda   heart_active             ;are we running
2757 73B7 D0 10                 bne   start_exit
2758 73B9
2759 73B9 AD 46 77              lda   progress_complete        ;Have we decided to stop already
2760 73BC 30 0B                 bmi   start_exit
2761 73BE
2762 73BE              not_stopped  
2763 73BE                       longa on
2764 73BE C2 30                 rep   #$30
2765 73C0 20 96 74              jsr   graphics_on              ;turn the graphics screen back on
2766 73C3
2767 73C3 A9 FF FF              lda   #$FFFF
2768 73C6 8D 4A 77              sta   armed                    ;yes we are armed
2769 73C9
2770 73C9              start_exit  
2771 73C9
2772 73C9 28                    plp                            ;restore interupts
2773 73CA AB                    plb   
2774 73CB 6B                    rtl   
2775 73CC
2776 73CC              ;=============================================================================
2777 73CC              ;stop_splash    stops the splash screen and enables text mode
2778 73CC              ;               only used by GLoader when the start app is P8 based
2779 73CC              ;=============================================================================
2780 73CC                       EXPORT stop_splash
2781 73CC              stop_splash  
2782 73CC 8B                    phb                            ;save data bank register
2783 73CD
2784 73CD 4B                    phk   
2785 73CE AB                    plb   
2786 73CF 08                    php   
2787 73D0 78                    sei                            ;stop!!!
2788 73D1                       longa on
2789 73D1                       longi on
2790 73D1 C2 30                 rep   #$30
2791 73D3 20 7E 75              jsr   boot_complete            ;fill up the progress bar & disable interupts
2792 73D6 28                    plp                            ;restore interrupts
2793 73D7 AB                    plb   
2794 73D8 6B                    rtl   
2795 73D9
2796 73D9              ;=============================================================================
2797 73D9              ;stop_scrn_chk  stops heartbeat task from checking for a change in the
2798 73D9              ;               screen
2799 73D9              ;
2800 73D9              ;=============================================================================
2801 73D9                       EXPORT stop_scrn_chk
2802 73D9              stop_scrn_chk  
2803 73D9 8B                    phb                            ;save data bank register
2804 73DA
2805 73DA 4B                    phk   
2806 73DB AB                    plb   
2807 73DC 08                    php   
2808 73DD 78                    sei                            ;stop!!!
2809 73DE                       longa on
2810 73DE                       longi on
2811 73DE C2 30                 rep   #$30
2812 73E0
2813 73E0 AD 52 77              lda   heart_active
2814 73E3 D0 06                 bne   stop_exit
2815 73E5
2816 73E5 9C 4A 77              stz   armed                    ;turn off check please
2817 73E8 20 96 74              jsr   graphics_on              ;turn the grphics screen back on
2818 73EB
2819 73EB              stop_exit  
2820 73EB 28                    plp                            ;restore interrupts
2821 73EC AB                    plb   
2822 73ED 6B                    rtl   
2823 73EE
2824 73EE              ;=============================================================================
2825 73EE              ;start_app_chk  This routine will start monitoring the application screens
2826 73EE              ;=============================================================================
2827 73EE                       EXPORT start_app_chk
2828 73EE              start_app_chk  
2829 73EE 8B                    phb   
2830 73EF 4B                    phk   
2831 73F0 AB                    plb   
2832 73F1
2833 73F1 08                    php   
2834 73F2 78                    sei   
2835 73F3 C2 30                 rep   #$30
2836 73F5                       longa on
2837 73F5                       longi on
2838 73F5
2839 73F5 AD 4C 77              lda   app_armed                ;see if we have already seen a change
2840 73F8 30 0F                 bmi   app_exit                 ;just exit please
2841 73FA
2842 73FA AD 52 77              lda   heart_active
2843 73FD D0 0A                 bne   app_exit
2844 73FF
2845 73FF 22 A8 73 00           jsl   start_scrn_chk           ;turn on graphics display please
2846 7403 A9 FF FF              lda   #$FFFF
2847 7406 8D 4C 77              sta   app_armed                ;turn on the application flag
2848 7409              app_exit  
2849 7409 28                    plp                            ;restore interupts
2850 740A AB                    plb   
2851 740B 6B                    rtl   
2852 740C
2853 740C
2854 740C              ;=============================================================================
2855 740C              ;Code that starts the heartbeat task
2856 740C              ;=============================================================================
2857 740C
2858 740C                       EXPORT restart_heartbeat
2859 740C              restart_heartbeat  
2860 740C              start_heartbeat  
2861 740C
2862 740C 08                    php                            ;save m and x bits
2863 740D 8B                    phb                            ;save caller's bank register
2864 740E
2865 740E 4B                    phk   
2866 740F AB                    plb                            ;set data bank to our bank please
2867 7410
2868 7410 C2 30                 rep   #$30
2869 7412 AD 52 77              lda   heart_active             ;are we running?
2870 7415 D0 21                 bne   not_active
2871 7417
2872 7417 AF 48 77 00           lda   >task_time
2873 741B 8F 3F 74 00           sta   >task_counter
2874 741F
2875 741F A9 00 00              lda   #^taskheader             ;address of task header
2876 7422 48                    pha   
2877 7423 A9 3B 74              lda   #taskheader
2878 7426 48                    pha   
2879 7427 A2 03 12              ldx   #$1203
2880 742A 22 00 00 E1           jsl   $E10000                  ;add a heartbeat task
2881 742E
2882 742E F4 02 00              pea   $0002                    ;now start the heart beat interupt
2883 7431 A2 03 23              ldx   #$2303
2884 7434 22 00 00 E1           jsl   $E10000
2885 7438
2886 7438              not_active  
2887 7438 AB                    plb                            ;restore caller's bank and status reg
2888 7439 28                    plp   
2889 743A 60                    rts   
2890 743B
2891 743B              ;===========================================================================
2892 743B              ;Heart Beat Task that will manage the progress bar
2893 743B              ;===========================================================================
2894 743B
2895 743B              taskheader  
2896 743B 90 9F 00 00           DC L:00000000                  ;link to the next task
2897 743F 01 00        task_counter DC W:1                     ;interupt each and every time
2898 7441 5A A5                 DC B:$5A,$A5                   ;signature for Ray
2899 7443
2900 7443 08                    php   
2901 7444 4B                    phk   
2902 7445 AB                    plb   
2903 7446 C2 30                 rep   #$30                     ;16 bit please
2904 7448
2905 7448 AD 46 77              lda   progress_complete
2906 744B 10 12                 bpl   not_complete             ;we have not completed progress
2907 744D
2908 744D 20 BD 75              jsr   do_update                ;update the file
2909 7450 90 05                 bcc   halt                     ;we are done
2910 7452 C9 07 00              cmp   #$0007                   ;OS busy?
2911 7455 F0 37                 beq   exit_task                ;we are not done yet.
2912 7457              halt      
2913 7457 20 A4 75              jsr   stop_heartbeat           ;finsh up please
2914 745A 9C 3F 74              stz   task_counter
2915 745D 80 2F                 bra   exit_task                ;we are gone
2916 745F
2917 745F              not_complete  
2918 745F              ;
2919 745F              ;The next two checks mean the following:
2920 745F              ; IF Application NOT running AND text enabled THEN skip draw
2921 745F              ;
2922 745F AD 4C 77              lda   app_armed                ;have we started looking for application?
2923 7462 30 0A                 bmi   @we_are_looking
2924 7464
2925 7464 E2 20                 sep   #$20                     ;8 bit mode for softswitch
2926 7466 AF 29 C0 00           lda   >display_switch
2927 746A C2 20                 rep   #$20
2928 746C 10 20                 bpl   exit_task                ;skip draw and time change if text is on.
2929 746E              @we_are_looking  
2930 746E EE 5E 77              inc   new_time
2931 7471
2932 7471 20 AB 74              jsr   check_screens            ;see if we are done??
2933 7474 90 0A                 bcc   no_change_yet
2934 7476
2935 7476 AD 4C 77              lda   app_armed                ;can we shut down yet?
2936 7479 10 05                 bpl   no_change_yet            ;no we cannot shutdown
2937 747B
2938 747B              quit_now  
2939 747B 20 7E 75              jsr   boot_complete
2940 747E 80 0E                 bra   exit_task                ;just a label
2941 7480
2942 7480              no_change_yet  
2943 7480 CE 3E 77              dec   local_counter
2944 7483 D0 09                 bne   exit_task
2945 7485 20 F3 74              jsr   add_progress
2946 7488 AD 3C 77              lda   our_counter
2947 748B 8D 3E 77              sta   local_counter
2948 748E
2949 748E              exit_task  
2950 748E AD 48 77              lda   task_time                ;reset the heartbeat timer
2951 7491 8D 3F 74              sta   task_counter
2952 7494 28                    plp   
2953 7495 6B                    rtl   
2954 7496
2955 7496              *
2956 7496              * Turn on graphics display and exit...
2957 7496              *
2958 7496              graphics_on  
2959 7496                       longa off
2960 7496 E2 20                 sep   #$20
2961 7498 AD 29 C0              lda   display_switch
2962 749B 29 BF                 and   #~linear_mode            ;clear linear bit
2963 749D 09 80                 ora   #graphics_mode           ;turn on the graphics screen again
2964 749F 8D 29 C0              sta   display_switch
2965 74A2              setup_scrn_char  
2966 74A2 A9 E5                 lda   #screen_char
2967 74A4 8F F7 07 E0           sta   >screen_test
2968 74A8                       longa on
2969 74A8 C2 20                 rep   #$20
2970 74AA 60                    rts   
2971 74AB
2972 74AB              ;============================================================================
2973 74AB              ;Check_Screen
2974 74AB              ;check screen will determine if we are thru booting the system disk.
2975 74AB              ;To determine if we are thru we monitor both the graphics and text based
2976 74AB              ;screens.  If we detect a change in one of the screens we decide that
2977 74AB              ;we must be thru booting the system.
2978 74AB              ;
2979 74AB              ;============================================================================
2980 74AB              check_screens  
2981 74AB AD 4A 77              lda   armed                    ;are we looking for a change?
2982 74AE 10 30                 bpl   chk_graphics             ;no we are not looking, But if graphics
2983 74B0                                                      ;change stop anyway.
2984 74B0
2985 74B0 AF F7 07 E0           lda   >screen_test
2986 74B4 29 FF 00              and   #$00FF
2987 74B7 C9 E5 00              cmp   #screen_char             ;should we switch to text?
2988 74BA F0 24                 beq   chk_graphics             ;check the graphics screen
2989 74BC
2990 74BC AD 4C 77              lda   app_armed                ;should we check 80 col. init?
2991 74BF 10 30                 bpl   skip_restore
2992 74C1
2993 74C1 AD 50 77              lda   hack_wait                ;wait two seconds please
2994 74C4 F0 05                 beq   chk_cursor
2995 74C6 CE 50 77              dec   hack_wait
2996 74C9 80 15                 bra   chk_graphics
2997 74CB
2998 74CB              chk_cursor  
2999 74CB AF BC 00 E1           lda   >os_kind                 ;is P8 running?
3000 74CF 29 FF 00              and   #$00FF                   ;(just another hack for switching)
3001 74D2 F0 1D                 beq   skip_restore
3002 74D4 AF 00 04 E1           lda   >pascal_cursor           ;check for cursor
3003 74D8 29 FF 00              and   #$00FF
3004 74DB C9 20 00              cmp   #$0020
3005 74DE D0 11                 bne   skip_restore
3006 74E0
3007 74E0              chk_graphics  
3008 74E0 AF 65 44 E1           lda   >graph_chk_loc           ;user now sees something nice
3009 74E4 C9 F0 00              cmp   #graph_chk_val
3010 74E7 D0 02                 bne   were_done                ;you bet we have booted
3011 74E9              dont_check  
3012 74E9 18                    clc   
3013 74EA 60                    rts   
3014 74EB              were_done  
3015 74EB A9 FF FF              lda   #$FFFF                   ;same as Application start
3016 74EE 8D 4C 77              sta   app_armed                ;set flag so we will shutdown
3017 74F1              skip_restore  
3018 74F1 38                    sec   
3019 74F2 60                    rts   
3020 74F3
3021 74F3              ;============================================================================
3022 74F3
3023 74F3              add_progress  
3024 74F3 D4 02                 pei   screen_ptr+2             ;push the high
3025 74F5 D4 00                 pei   screen_ptr
3026 74F7
3027 74F7 AD 29 C0              lda   display_switch           ;save the current mode
3028 74FA 48                    pha   
3029 74FB 09 40 00              ora   #$0040                   ;set linear mode so the fill works correctly
3030 74FE E2 20                 sep   #$20
3031 7500 8D 29 C0              sta   display_switch           ;turn on the graphics please
3032 7503 C2 20                 rep   #$20
3033 7505
3034 7505 A9 E9 57              lda   #<prog_draw_start
3035 7508 85 00                 sta   screen_ptr
3036 750A A9 E1 00              lda   #^prog_draw_start
3037 750D 85 02                 sta   screen_ptr+2
3038 750F
3039 750F
3040 750F              no_write  
3041 750F AD 44 77              lda   mask_index
3042 7512
3043 7512 AC 40 77              ldy   curr_index               ;where am I
3044 7515
3045 7515 C0 24 00              cpy   #36                      ;max index
3046 7518 90 05                 bcc   not_special
3047 751A
3048 751A C9 03 00              cmp   #$0003                   ;are we done?
3049 751D B0 44                 bcs   no_way                   ;we are done
3050 751F
3051 751F              not_special  
3052 751F 0A                    asl   a
3053 7520 AA                    tax   
3054 7521 BD 6E 75              lda   mask_tbl,x
3055 7524 8D 42 77              sta   mask
3056 7527
3057 7527 AE 44 77              ldx   mask_index
3058 752A E8                    inx   
3059 752B E0 08 00              cpx   #$0008
3060 752E 90 09                 bcc   store_mask
3061 7530 EE 40 77              inc   curr_index
3062 7533 EE 40 77              inc   curr_index
3063 7536 A2 00 00              ldx   #$0000
3064 7539 8E 44 77     store_mask stx   mask_index
3065 753C
3066 753C B7 00                 lda   [screen_ptr],y
3067 753E 2D 42 77              and   mask
3068 7541 97 00                 sta   [screen_ptr],y
3069 7543 20 31 77              jsr   bump_ptr                 ;next line
3070 7546
3071 7546 B7 00                 lda   [screen_ptr],y
3072 7548 2D 42 77              and   mask
3073 754B 97 00                 sta   [screen_ptr],y
3074 754D 20 31 77              jsr   bump_ptr                 ;next line
3075 7550
3076 7550 B7 00                 lda   [screen_ptr],y
3077 7552 2D 42 77              and   mask
3078 7555 97 00                 sta   [screen_ptr],y
3079 7557 20 31 77              jsr   bump_ptr                 ;next line
3080 755A
3081 755A B7 00                 lda   [screen_ptr],y
3082 755C 2D 42 77              and   mask
3083 755F 97 00                 sta   [screen_ptr],y
3084 7561 80 00                 bra   exit_please
3085 7563              no_way    
3086 7563
3087 7563              exit_please  
3088 7563 68                    pla   
3089 7564 8D 29 C0              sta   display_switch
3090 7567 68                    pla   
3091 7568 85 00                 sta   screen_ptr
3092 756A 68                    pla   
3093 756B 85 02                 sta   screen_ptr+2
3094 756D 60                    rts   
3095 756E
3096 756E 7F FF        mask_tbl DC B:$7F,$FF
3097 7570 4F FF                 DC B:$4F,$FF
3098 7572 F7 FF                 DC B:$F7,$FF
3099 7574 F4 FF                 DC B:$F4,$FF
3100 7576 FF 7F                 DC B:$FF,$7F
3101 7578 FF 4F                 DC B:$FF,$4F
3102 757A FF F7                 DC B:$FF,$F7
3103 757C FF F4                 DC B:$FF,$F4
3104 757E
3105 757E              ;=============================================================================
3106 757E                       EXPORT boot_complete
3107 757E              boot_complete  
3108 757E 8B                    phb   
3109 757F 4B                    phk   
3110 7580 AB                    plb   
3111 7581
3112 7581 20 B2 75              jsr   save_new_time
3113 7584 C9 07 00              cmp   #$0007                   ;OS Busy?
3114 7587 D0 0E                 bne   stop_everything
3115 7589
3116 7589 A9 00 80              lda   #$8000
3117 758C 8D 46 77              sta   progress_complete
3118 758F A9 B4 00              lda   #retry_delay             ;wait three seconds please
3119 7592 8D 48 77              sta   task_time
3120 7595 80 03                 bra   keep_beat
3121 7597
3122 7597              stop_everything  
3123 7597 20 A4 75              jsr   stop_heartbeat
3124 759A              keep_beat  
3125 759A AB                    plb   
3126 759B 60                    rts   
3127 759C
3128 759C                       EXPORT stop_progress
3129 759C              stop_progress  
3130 759C 8B                    phb   
3131 759D 4B                    phk   
3132 759E AB                    plb   
3133 759F 20 A4 75              jsr   stop_heartbeat
3134 75A2 AB                    plb   
3135 75A3 60                    rts   
3136 75A4
3137 75A4
3138 75A4              stop_heartbeat  
3139 75A4 F4 00 00              pea   TaskHeader>>16
3140 75A7 F4 3B 74              pea   TaskHeader
3141 75AA A2 03 13              ldx   #$1303                   ;remove heartbeat task please
3142 75AD 22 00 00 E1           jsl   $E10000
3143 75B1 60                    rts   
3144 75B2
3145 75B2              ;=============================================================================
3146 75B2              save_new_time  
3147 75B2 20 29 7C              jsr   divide                   ;get the new_time
3148 75B5 AD 3C 77              lda   our_counter
3149 75B8 CD 5E 77              cmp   new_time
3150 75BB F0 11                 beq   skip_update              ;do not update disk
3151 75BD              do_update  
3152 75BD AD 5E 77              lda   new_time                 ;is the time zero?
3153 75C0 F0 31                 beq   system_screwed
3154 75C2
3155 75C2 AF A8 00 E1           lda   >$e100a8                 ;is the OS loaded?
3156 75C6 29 FF 00              and   #$00FF                   ;clear address.
3157 75C9 C9 5C 00              cmp   #$005C                   ;look for a Jump long instruction
3158 75CC F0 04                 beq   sys_loaded
3159 75CE              not_gsos  
3160 75CE              skip_update  
3161 75CE A9 00 00              lda   #$0000
3162 75D1 60                    rts   
3163 75D2
3164 75D2              sys_loaded  
3165 75D2 AF BC 00 E1           lda   >$e100bc                 ;look at the OS kind byte.
3166 75D6 29 FF 00              and   #$00FF
3167 75D9 C9 01 00              cmp   #$0001                   ;is GS/OS running?
3168 75DC D0 F0                 bne   not_gsos                 ;P8 is running so exit please
3169 75DE
3170 75DE AF F0 B9 00           lda   >dev_start_flag          ;see if Ray is starting up still.
3171 75E2 F0 05                 beq   @do_set_info             ;Ray is not busy!!!
3172 75E4 A9 07 00              lda   #$0007                   ;simulate OS Busy please.
3173 75E7 38                    sec   
3174 75E8 60                    rts   
3175 75E9              @do_set_info  
3176 75E9 22 A8 00 E1           jsl   $e100a8                  ;call GS/OS
3177 75ED 05 20                 DC W:$2005                     ;set file info
3178 75EF 54 77 00 00           DC L:info_list
3179 75F3
3180 75F3              system_screwed  
3181 75F3 60                    rts   
3182 75F4
3183 75F4              ;=============================================================================
3184 75F4              draw_box  
3185 75F4 A9 C5 43              lda   #<box_start              ;start of box
3186 75F7 85 00                 sta   screen_ptr
3187 75F9
3188 75F9 20 F0 76              jsr   draw_white
3189 75FC 20 01 77              jsr   draw_black
3190 75FF A2 2D 00              ldx   #45                      ;draw 45 middle lines
3191 7602 20 1A 77     loop1    jsr   draw_middle
3192 7605 CA                    dex   
3193 7606 D0 FA                 bne   loop1
3194 7608 20 01 77              jsr   draw_black
3195 760B 4C F0 76              jmp   draw_white
3196 760E
3197 760E              ;=============================================================================
3198 760E              draw_icon  
3199 760E A9 EC 46              lda   #<icon_start
3200 7611 85 00                 sta   screen_ptr
3201 7613
3202 7613 A9 88 77              lda   #icon
3203 7616 85 04                 sta   icon_ptr
3204 7618
3205 7618 A2 20 00              ldx   #icon_height
3206 761B              outter_loop1  
3207 761B A0 0C 00              ldy   #icon_width-2
3208 761E 20 AF 76              jsr   copy_line                ;copy the entire line
3209 7621
3210 7621 18                    clc   
3211 7622 A5 04                 lda   icon_ptr
3212 7624 69 0E 00              adc   #icon_width
3213 7627 85 04                 sta   icon_ptr
3214 7629
3215 7629 CA                    dex   
3216 762A D0 EF                 bne   outter_loop1
3217 762C 60                    rts                            ;we are done
3218 762D
3219 762D              ;=============================================================================
3220 762D              draw_text  
3221 762D A9 89 49              lda   #<text1_start
3222 7630 85 00                 sta   screen_ptr
3223 7632
3224 7632 A9 48 79              lda   #text1
3225 7635 85 04                 sta   icon_ptr
3226 7637
3227 7637 A2 09 00              ldx   #text1_height
3228 763A              outter_loop2  
3229 763A A0 23 00              ldy   #text1_width-2
3230 763D 20 AF 76              jsr   copy_line                ;move the entire line
3231 7640
3232 7640 18                    clc   
3233 7641 A5 04                 lda   icon_ptr
3234 7643 69 25 00              adc   #text1_width
3235 7646 85 04                 sta   icon_ptr
3236 7648
3237 7648 CA                    dex   
3238 7649 D0 EF                 bne   outter_loop2
3239 764B
3240 764B              second_line  
3241 764B A9 6F 50              lda   #<text2_start
3242 764E 85 00                 sta   screen_ptr
3243 7650
3244 7650 A9 95 7A              lda   #text2
3245 7653 85 04                 sta   icon_ptr
3246 7655
3247 7655 A2 0A 00              ldx   #text2_height
3248 7658              @outter_loop2  
3249 7658 A0 14 00              ldy   #text2_width-2
3250 765B 20 AF 76              jsr   copy_line                ;copy bitmap line to screen memory
3251 765E
3252 765E 18                    clc   
3253 765F A5 04                 lda   icon_ptr
3254 7661 69 16 00              adc   #text2_width
3255 7664 85 04                 sta   icon_ptr
3256 7666
3257 7666 CA                    dex   
3258 7667 D0 EF                 bne   @outter_loop2
3259 7669
3260 7669 60                    rts                            ;we are done
3261 766A
3262 766A              ;=============================================================================
3263 766A                       entry draw_ext_off
3264 766A              draw_ext_off  
3265 766A A9 E1 00              lda   #$00E1
3266 766D 85 02                 sta   screen_ptr+2
3267 766F
3268 766F              *** added 20-Oct-92 DAL
3269 766F              white_out_area PointAddress 77,250 
3270 766F A9 5E 50              lda   #<white_out_area
3271 7672 85 00                 sta   screen_ptr
3272 7674 A2 09 00              ldx   #9                       ;store 9 lines
3273 7677 A9 FF FF     @storeLine lda   #$ffff
3274 767A A0 38 00              ldy   #56
3275 767D 97 00        @storeWord sta   [<screen_ptr],y
3276 767F 88                    dey   
3277 7680 88                    dey   
3278 7681 10 FA                 bpl   @storeWord
3279 7683 18                    clc   
3280 7684 A5 00                 lda   <screen_ptr
3281 7686 69 A0 00              adc   #$a0
3282 7689 85 00                 sta   <screen_ptr
3283 768B CA                    dex   
3284 768C 10 E9                 bpl   @storeLine
3285 768E              *** end 20-Oct-92
3286 768E
3287 768E A9 10 51              lda   #<ext_off_start
3288 7691 85 00                 sta   screen_ptr
3289 7693
3290 7693 A9 71 7B              lda   #ext_off
3291 7696 85 04                 sta   icon_ptr
3292 7698 64 06                 stz   icon_ptr+2
3293 769A
3294 769A A2 08 00              ldx   #ext_off_height
3295 769D              @loop     
3296 769D A0 15 00              ldy   #ext_off_width-2
3297 76A0 20 AF 76              jsr   copy_line                ;copy bitmap line to screen memory
3298 76A3
3299 76A3 18                    clc   
3300 76A4 A5 04                 lda   icon_ptr
3301 76A6 69 17 00              adc   #ext_off_width
3302 76A9 85 04                 sta   icon_ptr
3303 76AB
3304 76AB CA                    dex   
3305 76AC D0 EF                 bne   @loop
3306 76AE
3307 76AE 60                    rts                            ;we are done
3308 76AF
3309 76AF              ;=============================================================================
3310 76AF              copy_line                               ;copies bitmap from array to screen memory
3311 76AF              @loop     
3312 76AF B7 04                 lda   [icon_ptr],y
3313 76B1 97 00                 sta   [screen_ptr],y
3314 76B3 88                    dey   
3315 76B4 F0 F9                 beq   @loop
3316 76B6 88                    dey   
3317 76B7 10 F6                 bpl   @loop                    ;move the entire line
3318 76B9 80 76                 bra   bump_ptr
3319 76BB
3320 76BB              ;=============================================================================
3321 76BB              draw_progress  
3322 76BB A9 49 57              lda   #<progress_start
3323 76BE 85 00                 sta   screen_ptr
3324 76C0
3325 76C0 20 CC 76              jsr   draw_prog_line           ;draw one black line please
3326 76C3 A2 04 00              ldx   #$0004
3327 76C6              prog_loop  
3328 76C6 20 DD 76              jsr   draw_prog_end
3329 76C9 CA                    dex   
3330 76CA D0 FA                 bne   prog_loop
3331 76CC              ;fall through to draw_prog_line
3332 76CC
3333 76CC              ;=============================================================================
3334 76CC              draw_prog_line  
3335 76CC A0 23 00              ldy   #35
3336 76CF A9 00 00              lda   #$0000
3337 76D2 97 00                 sta   [screen_ptr],y
3338 76D4 88                    dey   
3339 76D5 97 00        loopA1   sta   [screen_ptr],y
3340 76D7 88                    dey   
3341 76D8 88                    dey   
3342 76D9 10 FA                 bpl   loopA1
3343 76DB 80 54                 bra   bump_ptr                 ;move to the next line please
3344 76DD
3345 76DD              ;=============================================================================
3346 76DD              draw_prog_end  
3347 76DD A7 00                 lda   [screen_ptr]
3348 76DF 29 0F FF              and   #$FF0F
3349 76E2 87 00                 sta   [screen_ptr]
3350 76E4
3351 76E4 A0 23 00              ldy   #35
3352 76E7 B7 00                 lda   [screen_ptr],y
3353 76E9 29 FF F0              and   #$F0FF
3354 76EC 97 00                 sta   [screen_ptr],y
3355 76EE 80 41                 bra   bump_ptr                 ;move to the next line please
3356 76F0
3357 76F0              ;=============================================================================
3358 76F0              draw_white  
3359 76F0 A0 55 00              ldy   #85                      ;move 86 bytes please
3360 76F3 A9 FF FF              lda   #$FFFF
3361 76F6 97 00                 sta   [screen_ptr],y
3362 76F8 88                    dey   
3363 76F9 97 00        loopA    sta   [screen_ptr],y
3364 76FB 88                    dey   
3365 76FC 88                    dey   
3366 76FD 10 FA                 bpl   loopA
3367 76FF 80 30                 bra   bump_ptr                 ;move to the next line please
3368 7701
3369 7701              ;=============================================================================
3370 7701              draw_black  
3371 7701 A0 55 00              ldy   #85                      ;move 86 bytes please
3372 7704 A9 00 0F              lda   #$0F00
3373 7707 97 00                 sta   [screen_ptr],y
3374 7709 88                    dey   
3375 770A A9 00 00              lda   #$0000
3376 770D 97 00        loopB    sta   [screen_ptr],y
3377 770F 88                    dey   
3378 7710 88                    dey   
3379 7711 D0 FA                 bne   loopB
3380 7713 A9 F0 00              lda   #$00F0
3381 7716 97 00                 sta   [screen_ptr],y
3382 7718 80 17                 bra   bump_ptr                 ;move to the next line please
3383 771A
3384 771A              ;=============================================================================
3385 771A              draw_middle  
3386 771A
3387 771A A0 55 00              ldy   #85                      ;move 86 bytes please
3388 771D A9 FF 0F              lda   #$0FFF
3389 7720 97 00                 sta   [screen_ptr],y
3390 7722 88                    dey   
3391 7723 A9 FF FF              lda   #$FFFF
3392 7726 97 00        loopC    sta   [screen_ptr],y
3393 7728 88                    dey   
3394 7729 88                    dey   
3395 772A D0 FA                 bne   loopC
3396 772C A9 F0 FF              lda   #$FFF0
3397 772F 97 00                 sta   [screen_ptr],y
3398 7731              ;fall through to bump_ptr to move to the next line
3399 7731
3400 7731              bump_ptr  
3401 7731 18                    clc   
3402 7732 A5 00                 lda   screen_ptr
3403 7734 69 A0 00              adc   #123+37                  ;point to the next line please
3404 7737 85 00                 sta   screen_ptr
3405 7739 60                    rts   
3406 773A
3407 773A              ;=============================================================================
3408 773A
3409 773A 00 00        total_time DC W:00                      ;time during last boot
3410 773C 02 00        our_counter DC W:5
3411 773E 02 00        local_counter DC W:00
3412 7740 1E 00        curr_index DC W:0
3413 7742 FF F7        mask     DC W:0
3414 7744 07 00        mask_index DC W:0
3415 7746 00 00        progress_complete DC W:00
3416 7748 01 00        task_time DC W:00
3417 774A FF FF        armed    DC W:00
3418 774C FF FF        app_armed DC W:00
3419 774E 00 00        text_counter DC W:00
3420 7750 05 00        hack_wait DC W:120                      ;wait two seconds
3421 7752                       EXPORT heart_active
3422 7752 00 00        heart_active DC W:00
3423 7754
3424 7754 04 00        info_list DC W:04                       ;thru aux type field
3425 7756 62 77 00 00           DC L:gs_os_path
3426 775A E3 00                 DC W:$E3                       ;access
3427 775C F9 00                 DC W:$F9                       ;file type
3428 775E                       EXPORT new_time
3429 775E              new_time  
3430 775E 02 00 00 00           DC L:00                        ;real time to boot
3431 7762
3432 7762 14 00        gs_os_path DC W:20
3433 7764 2A 3A 73 79           DC B:'*:system:start.gs.os'
3434 7778
3435 7778
3436 7778 00 00        palette  DC W:$0000                     ; black
3437 777A 00 0F                 DC W:$0F00                     ; red
3438 777C F0 00                 DC W:$00F0                     ; green
3439 777E FF 0F                 DC W:$0FFF                     ; white
3440 7780 00 00                 DC W:$0000                     ; black
3441 7782 0F 00                 DC W:$000F                     ; blue
3442 7784 F0 0F                 DC W:$0FF0                     ; yellow
3443 7786 FF 0F                 DC W:$0FFF                     ; white
3444 7788
3445 7788
3446 7788              icon_height equ   32
3447 7788              icon_width equ   ((28-1)>>1)+1
3448 7788
3449 7788              icon      
3450 7788 FF FF FF FF           hex   FFFFFFFFFFFFFFFFFFFFFFFFFFFF
3451 7796 FF FF FF FF           hex   FFFFFFFFF030FFFFFFFFFFFFFFFF
3452 77A4 FF FF FF FF           hex   FFFFFFFF03FF0FFFFFFFFFFFFFFF
3453 77B2 FF FF FF F0           hex   FFFFFFF03FFFF0FFFFFFFFFFFFFF
3454 77C0 FF FF FF 03           hex   FFFFFF03FFFFFF0FFFFFFFFFFFFF
3455 77CE FF FF F0 3F           hex   FFFFF03FFCFFFFF3030FFFFFFFFF
3456 77DC FF FF 03 FF           hex   FFFF03FFFFCFFFF0FFF0FFFFFFFF
3457 77EA FF F0 3F FC           hex   FFF03FFCFFFCFF0FFF00FFFFFFFF
3458 77F8 FF 33 FF FF           hex   FF33FFFFCFFFF0FFF0F0FFFFFFFF
3459 7806 FF 00 FF FF           hex   FF00FFFFFCFF0FFF0FF0FFFFFFFF
3460 7814 FF 03 0F FF           hex   FF030FFFFFF0FFF0FDF0FFFFFFFF
3461 7822 FF 03 30 FF           hex   FF0330FFFF0FFF0FDDF0FFFFFFFF
3462 7830 FF F3 33 0F           hex   FFF3330FF0FFF0FDDDF033FFFFFF
3463 783E FF 0F 33 30           hex   FF0F3330F0FF0FDDDDF0FF3FFFFF
3464 784C FF 03 F3 33           hex   FF03F3333C30FDDDDF0FFF3FFFFF
3465 785A FF 03 3F 33           hex   FF033F3330F0FDDDF00FFF3FFFFF
3466 7868 FF 03 33 F3           hex   FF0333F330F0FDDF0F0FFFF3FFFF
3467 7876 FF 03 33 3F           hex   FF03333F30F0FDF0FF0FFFFF3CFF
3468 7884 FF 03 33 33           hex   FF033333F0F0FF0FFF0F0FFFCCCF
3469 7892 FF F0 33 33           hex   FFF033333F00F0FFF0F0F0FFFCCF
3470 78A0 FF FF 03 33           hex   FFFF033333F00FFF0F0F3F0FFFFF
3471 78AE FF FF F0 33           hex   FFFFF033330FFAF0F0FF33F0FFFF
3472 78BC FF FF FF 03           hex   FFFFFF03330F4F0F0F3FFF0FFFFF
3473 78CA FF FF FF F0           hex   FFFFFFF0330FF0F0F3F3F0FFFFFF
3474 78D8 FF FF F4 FF           hex   FFFFF4FF030F0F0F3F3F0FFFFFFF
3475 78E6 FF FF 4F FF           hex   FFFF4FFFF0F0F0F3F3F0FFFFFFFF
3476 78F4 FF 44 F4 4F           hex   FF44F44FFF0F0F3F3F0FFFFFFFFF
3477 7902 F4 FF FF FF           hex   F4FFFFFFFFF0FFF3F0FFFFFFFFFF
3478 7910 F4 FF FF FF           hex   F4FFFFFFFFFC0FFF0FFFFFFFFFFF
3479 791E FF 4F 4F 4F           hex   FF4F4F4FFFFFC0F0FFFFFFFFFFFF
3480 792C FF F4 F4 FF           hex   FFF4F4FFFFFFFF0FFFFFFFFFFFFF
3481 793A FF FF FF FF           hex   FFFFFFFFFFFFFFFFFFFFFFFFFFFF
3482 7948
3483 7948              text1_start PointAddress 66,292 
3484 7948              text1_width equ   $0025
3485 7948              text1_height equ   $0009
3486 7948              text1     
3487 7948 FC 3F FC 3F           hex   FC3FFC3FFFFC0FFFFFFFFFFFFFFFFFFFFFFC3F
3488 795B FF FF FF FC           hex   FFFFFFFC3FC3FFFFFFFFFC3FC3FFFFFFFFFF
3489 796D
3490 796D FC 3F FC 3F           hex   FC3FFC3FFFFF0FFFFFFFFFFFFFFFFFFFFFFC3F
3491 7980 FF FF FF FC           hex   FFFFFFFC3FC3FFFFFFFFFC3FC3FFFFFFFFFF
3492 7992
3493 7992 FC 3C 3C 3F           hex   FC3C3C3F00FF0FF00FF00FC00C0FF00FFFF00F
3494 79A5 F0 0F FF F0           hex   F00FFFF00FC00FF00FFFFC3FC3FF00FF00FF
3495 79B7
3496 79B7 FF 0C 30 FC           hex   FF0C30FC3C3F0FC3C3C3C3C0C0C3C3C3FFFC3F
3497 79CA C3 C3 FF FC           hex   C3C3FFFC3FC0C3C3C3FFFC3FC3FC3C3C3C3F
3498 79DC
3499 79DC FF 00 00 FC           hex   FF0000FC3C3F0FC3FFC3C3C3C3C3C3C3FFFC3F
3500 79EF C3 C3 FF FC           hex   C3C3FFFC3FC3C3C3C3FFFC3FC3FC3FFC3FFF
3501 7A01
3502 7A01 FF 00 00 FC           hex   FF0000FC003F0FC3FFC3C3C3C3C3C003FFFC3F
3503 7A14 C3 C3 FF FC           hex   C3C3FFFC3FC3C3C003FFFC3FC3FC303F00FF
3504 7A26
3505 7A26 FF C3 C3 FC           hex   FFC3C3FC3FFF0FC3FFC3C3C3C3C3C3FFFFFC3F
3506 7A39 C3 C3 FF FC           hex   C3C3FFFC3FC3C3C3FFFFFC3FC3FC3C3FFC3F
3507 7A4B
3508 7A4B FF C3 C3 FC           hex   FFC3C3FC3C3F0FC3C3C3C3C3C3C3C3C3FFFC3F
3509 7A5E C3 C3 FF FC           hex   C3C3FFFC3FC3C3C3C3FFFC3FC3FC3C3C3C3F
3510 7A70
3511 7A70 FF C3 C3 FF           hex   FFC3C3FF00FF0FF00FF00FC3C3C3F00FFFFF03
3512 7A83 F0 0F FF FF           hex   F00FFFFF03C3C3F00FFFFC3FC3FF00FF00FF
3513 7A95
3514 7A95              *** "System 6.0"
3515 7A95              ;text2_start	PointAddress 78,330
3516 7A95              ;text2_width	equ	$0012
3517 7A95              ;text2_height	equ	$0008
3518 7A95              ;
3519 7A95              ;text2
3520 7A95              ;	HEX	F00FFFFFFFFFFFFFFFFFFFFFFFFC03FFFF00
3521 7A95              ;	HEX	C3C3FFFFFFFFF0FFFFFFFFFFFFF0FFFFFCF0
3522 7A95              ;	HEX	C3FFC3C3F00FC00FF00F0003FFF003FFF0F0
3523 7A95              ;	HEX	F00FC3C3C3FFF0FFC3C30C30FFF0F0FFF0F0
3524 7A95              ;	HEX	FFC3C303F00FF0FFC0030C30FFF0F0FFF0F0
3525 7A95              ;	HEX	C3C3F0C3FFC3F0C3C3FF0C30FFF0F0FFF0F3
3526 7A95              ;	HEX	F00FCFC3F00FFC0FF00F0C30FFFC03F0F00F
3527 7A95              ;	HEX	FFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFF
3528 7A95
3529 7A95              ;*** 17-Feb-92 DAL -- "System 6.1 under construction"
3530 7A95              ;;
3531 7A95              ;; This file was produced by a somewhat automated sequence
3532 7A95              ;; Please do not modify by hand unless you're SURE you know what you're doing!
3533 7A95              ;;
3534 7A95              ;text2_start	PointAddress 77,258
3535 7A95              ;text2_width	equ	$0036
3536 7A95              ;text2_height	equ	$0009
3537 7A95              ;
3538 7A95              ;text2
3539 7A95              ;	HEX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
3540 7A95              ;	HEX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
3541 7A95              ;	HEX FFFFFFFF
3542 7A95              ;	
3543 7A95              ;	HEX FF00FFFFFFFFFFFFFFFFFFFFFFFFC03FFFF0FFFFFFFFFFFFFF
3544 7A95              ;	HEX 0FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC3F
3545 7A95              ;	HEX FFFFFFFF
3546 7A95              ;
3547 7A95              ;	HEX FC3C3FFFFFFFFF0FFFFFFFFFFFFF0FFFFF00FFFFFFFFFFFFFF
3548 7A95              ;	HEX 0FFFFFFFFFFFFFFFFFFFFFFFFFFF0FFFFFFFFFFFFFFC3FFFFF
3549 7A95              ;	HEX FFFFFFFF
3550 7A95              ;
3551 7A95              ;	HEX FC3FFC3C3F00FC00FF00F0003FFF003FFFF0FFFF0F0F003FC0
3552 7A95              ;	HEX 0FC03F0C3FFF00FF00FC00FF00FC00FC30F0F0FC03F003F03F
3553 7A95              ;	HEX C03F003F
3554 7A95              ;
3555 7A95              ;	HEX FF00FC3C3C3FFF0FFC3C30C30FFF0F0FFFF0FFFF0F0F0F0F0F
3556 7A95              ;	HEX 0F0F0F03FFFC3C3C3C3C3C3C3FFF0FFC0FF0F0F0F0FC3FFC3F
3557 7A95              ;	HEX 0F0F0F0F
3558 7A95              ;
3559 7A95              ;	HEX FFFC3C303F00FF0FFC0030C30FFF0F0FFFF0FFFF0F0F0F0F0F
3560 7A95              ;	HEX 0F000F0FFFFC3FFC3C3C3C3F00FF0FFC3FF0F0F0FFFC3FFC3F
3561 7A95              ;	HEX 0F0F0F0F
3562 7A95              ;
3563 7A95              ;	HEX FC3C3F0C3FFC3F0C3C3FF0C30FFF0F0FFFF0FFFF0F0F0F0F0F
3564 7A95              ;	HEX 0F0FFF0FFFFC3C3C3C3C3C3FFC3F0C3C3FF0F0F0F0FC30FC3F
3565 7A95              ;	HEX 0F0F0F0F
3566 7A95              ;
3567 7A95              ;	HEX FF00FCFC3F00FFC0FF00F0C30FFFC03F0F000FFFC00F0F0FC0
3568 7A95              ;	HEX 0FC03F0FFFFF00FF00FC3C3F00FFC0FC3FFC00FC03FF03F00F
3569 7A95              ;	HEX C03F0F0F
3570 7A95              ;
3571 7A95              ;	HEX FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
3572 7A95              ;	HEX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
3573 7A95              ;	HEX FFFFFFFF
3574 7A95              ;*** end 17-Feb-92
3575 7A95
3576 7A95              ;*** 26-May-92 DAL -- "System 6.0.1 under construction"
3577 7A95              ;;
3578 7A95              ;; This file was produced by a somewhat automated sequence
3579 7A95              ;; Please do not modify by hand unless you're SURE you know what you're doing!
3580 7A95              ;;
3581 7A95              ;text2_start	PointAddress 77,254
3582 7A95              ;text2_width	equ	$0039
3583 7A95              ;text2_height	equ	$0009
3584 7A95              ;
3585 7A95              ;text2
3586 7A95              ;	HEX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
3587 7A95              ;	HEX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
3588 7A95              ;	HEX FFFFFFFFFFFFFF
3589 7A95              ;
3590 7A95              ;	HEX FF00FFFFFFFFFFFFFFFFFFFFFFFFC03FFFF00FFFF0FFFFFFFF
3591 7A95              ;	HEX FFFFFF0FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
3592 7A95              ;	HEX FFFC3FFFFFFFFF
3593 7A95              ;
3594 7A95              ;	HEX FC3C3FFFFFFFFF0FFFFFFFFFFFFF0FFFFFCF0FFF00FFFFFFFF
3595 7A95              ;	HEX FFFFFF0FFFFFFFFFFFFFFFFFFFFFFFFFFF0FFFFFFFFFFFFFFC
3596 7A95              ;	HEX 3FFFFFFFFFFFFF
3597 7A95              ;
3598 7A95              ;	HEX FC3FFC3C3F00FC00FF00F0003FFF003FFF0F0FFFF0FFFF0F0F
3599 7A95              ;	HEX 003FC00FC03F0C3FFF00FF00FC00FF00FC00FC30F0F0FC03F0
3600 7A95              ;	HEX 03F03FC03F003F
3601 7A95              ;
3602 7A95              ;	HEX FF00FC3C3C3FFF0FFC3C30C30FFF0F0FFF0F0FFFF0FFFF0F0F
3603 7A95              ;	HEX 0F0F0F0F0F0F03FFFC3C3C3C3C3C3C3FFF0FFC0FF0F0F0F0FC
3604 7A95              ;	HEX 3FFC3F0F0F0F0F
3605 7A95              ;
3606 7A95              ;	HEX FFFC3C303F00FF0FFC0030C30FFF0F0FFF0F0FFFF0FFFF0F0F
3607 7A95              ;	HEX 0F0F0F0F000F0FFFFC3FFC3C3C3C3F00FF0FFC3FF0F0F0FFFC
3608 7A95              ;	HEX 3FFC3F0F0F0F0F
3609 7A95              ;
3610 7A95              ;	HEX FC3C3F0C3FFC3F0C3C3FF0C30FFF0F0FFF0F3FFFF0FFFF0F0F
3611 7A95              ;	HEX 0F0F0F0F0FFF0FFFFC3C3C3C3C3C3FFC3F0C3C3FF0F0F0F0FC
3612 7A95              ;	HEX 30FC3F0F0F0F0F
3613 7A95              ;
3614 7A95              ;	HEX FF00FCFC3F00FFC0FF00F0C30FFFC03F0F00FF0F000FFFC00F
3615 7A95              ;	HEX 0F0FC00FC03F0FFFFF00FF00FC3C3F00FFC0FC3FFC00FC03FF
3616 7A95              ;	HEX 03F00FC03F0F0F
3617 7A95              ;
3618 7A95              ;	HEX FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
3619 7A95              ;	HEX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
3620 7A95              ;	HEX FFFFFFFFFFFFFF
3621 7A95              ;*** end 26-May-92
3622 7A95
3623 7A95              *** 1-Apr-93 SS -- "System 6.0.1"
3624 7A95              ;
3625 7A95              ; This file was produced by a somewhat automated sequence
3626 7A95              ; Please do not modify by hand unless you're SURE you know what you're doing!
3627 7A95              ;
3628 7A95              text2_start PointAddress 77,318 
3629 7A95              text2_width equ   $0016
3630 7A95              text2_height equ   $000a
3631 7A95
3632 7A95              text2     
3633 7A95 FF FF FF FF           HEX   FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
3634 7AAB FF 00 FF FF           HEX   FF00FFFFFFFFFFFFFFFFFFFFFFFFC03FFFF00FFFF0FF
3635 7AC1 FC 3C 3F FF           HEX   FC3C3FFFFFFFFF0FFFFFFFFFFFFF0FFFFFCF0FFF00FF
3636 7AD7 FC 3F FC 3C           HEX   FC3FFC3C3F00FC00FF00F0003FFF003FFF0F0FFFF0FF
3637 7AED FF 00 FC 3C           HEX   FF00FC3C3C3FFF0FFC3C30C30FFF0F0FFF0F0FFFF0FF
3638 7B03 FF FC 3C 30           HEX   FFFC3C303F00FF0FFC0030C30FFF0F0FFF0F0FFFF0FF
3639 7B19 FC 3C 3F 0C           HEX   FC3C3F0C3FFC3F0C3C3FF0C30FFF0F0FFF0F3FFFF0FF
3640 7B2F FF 00 FC FC           HEX   FF00FCFC3F00FFC0FF00F0C30FFFC03F0F00FF0F000F
3641 7B45 FF FF FF 00           HEX   FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
3642 7B5B FF FF FF FF           HEX   FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
3643 7B71              *** end 1-Apr-93
3644 7B71
3645 7B71              Ext_Off_start PointAddress 78,320 
3646 7B71              Ext_Off_width equ   $0017
3647 7B71              Ext_Off_height equ   $0008
3648 7B71
3649 7B71              Ext_Off   
3650 7B71 CF C3 FF FF           HEX   CFC3FFFFFFF00FFFFFF0FFFFFFFFFFFC3C00FF
3651 7B84 00 FF FF FF           HEX   00FFFFFF
3652 7B88 C3 C3 FF FF           HEX   C3C3FFFFFFFC3FFFFFFFFF0FFFFFFFF0FC3C3C
3653 7B9B 3C 3F FF FF           HEX   3C3FFFFF
3654 7B9F C0 C3 F0 0F           HEX   C0C3F00FFFFC3FC00FC0FC00FF00FFC3FC3C3C
3655 7BB2 3C 3F 00 FF           HEX   3C3F00FF
3656 7BB6 C0 03 C3 C3           HEX   C003C3C3FFFC3FC3C3F0FF0FFC3FFF0FFC3C3C
3657 7BC9 3C 3C 3F FF           HEX   3C3C3FFF
3658 7BCD C3 03 C3 C3           HEX   C303C3C3FFFC3FC3C3F0FF0FFF00FC3FFC3C3C
3659 7BE0 00 3F 00 FF           HEX   003F00FF
3660 7BE4 C3 C3 C3 C3           HEX   C3C3C3C3FFFC3FC3C3F0FF0C3FFC30FFFC3C3C
3661 7BF7 3C 3F FC 3F           HEX   3C3FFC3F
3662 7BFB C3 F3 F0 0F           HEX   C3F3F00FFFF00FC3C3C03FC0FF00F3FFFC00FC
3663 7C0E 3C 3F 00 FF           HEX   3C3F00FF
3664 7C12 FF FF FF FF           HEX   FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
3665 7C25 FF FF FF FF           HEX   FFFFFFFF
3666 7C29
3667 7C29                       ENDP 
3668 7C29
3669 7C29              ******************************************************************************
3670 7C29              *
3671 7C29              *        Name:  divide
3672 7C29              *
3673 7C29              * Description:  Does 16 bit division. dividend/divisor = dividend w/remainder.
3674 7C29              *
3675 7C29              *     Created:  June 20, 1988
3676 7C29              *    Modified:  June 20, 1988
3677 7C29              *      Author:  Bryan Atsatt  (adapted from '6502 Software Design')
3678 7C29              *
3679 7C29              *       Entry:  jsr
3680 7C29              *
3681 7C29              *       Input:  A = undefined
3682 7C29              *               X = undefined
3683 7C29              *               Y = undefined
3684 7C29              *               P = nvmxdizc
3685 7C29              *                   ..000...
3686 7C29              *               B = K
3687 7C29              *
3688 7C29              *               new_time                ;16 bit new_time.
3689 7C29              *               divisor                 ;16 bit divisor.
3690 7C29              *
3691 7C29              *      Output:  A = undefined
3692 7C29              *               X = undefined
3693 7C29              *               Y = undefined
3694 7C29              *               P = nvmxdizc
3695 7C29              *                   ..000..0
3696 7C29              *               B = K
3697 7C29              *
3698 7C29              *               new_time                ;quotient
3699 7C29              *               remainder               ;remainder
3700 7C29              *
3701 7C29              *        Uses:  All registers
3702 7C29              *               new_time
3703 7C29              *               divisor
3704 7C29              *               remainder
3705 7C29              *
3706 7C29              * Copyright Apple Computer, Inc. 1987-1993  All rights reserved.
3707 7C29              ******************************************************************************
3708 7C29
3709 7C29              divide   PROC 
3710 7C29
3711 7C29              *
3712 7C29              * Initialize...
3713 7C29              *
3714 7C29 A2 20 00              ldx   #32                      ;Get bit count.
3715 7C2C 9C 6A 7C              stz   remainder                ;Clear remainder.
3716 7C2F 9C 6C 7C              stz   remainder+2
3717 7C32              *
3718 7C32              * Do division and exit...
3719 7C32              *
3720 7C32 0E 5E 77     div_loop asl   new_time                 ;Shift new_time & quotient left.
3721 7C35 2E 60 77              rol   new_time+2
3722 7C38 2E 6A 7C              rol   remainder                ;Shift partial new_time left.
3723 7C3B 2E 6C 7C              rol   remainder+2
3724 7C3E 38                    sec                            ;Subtract low bytes.
3725 7C3F AD 6A 7C              lda   remainder
3726 7C42 ED 66 7C              sbc   divisor
3727 7C45 A8                    tay                            ;Save low result.
3728 7C46 AD 6C 7C              lda   remainder+2              ;Subtract high bytes.
3729 7C49
3730 7C49 ED 68 7C              sbc   divisor+2                ;Divisor > new_time?
3731 7C4C 90 09                 bcc   next_bit                 ;Yes.
3732 7C4E EE 5E 77              inc   new_time                 ;No, set bit in quotient.
3733 7C51 8C 6A 7C              sty   remainder                ;Enter result in partial new_time.
3734 7C54 8D 6C 7C              sta   remainder+2
3735 7C57 CA           next_bit dex                            ;Done all bits?
3736 7C58 D0 D8                 bne   div_loop                 ;No, so loop.
3737 7C5A AD 6A 7C              lda   remainder                ;do we need to bump the result?
3738 7C5D C9 4A 00              cmp   #$004A                   ;the magic value
3739 7C60 90 03                 bcc   no_bump
3740 7C62 EE 5E 77              inc   new_time
3741 7C65              no_bump   
3742 7C65 60                    rts                            ;Yes, so exit.
3743 7C66
3744 7C66 94 00 00 00  divisor  DC L:148
3745 7C6A 6B 00 00 00  remainder DC L:00
3746 7C6E
3747 7C6E                       ENDP 
3748 7C6E
3749 7C6E
3750 7C6E
3751 7C6E                       eject 
3752 7C6E              ;===============================================================================
3753 7C6E              ; loader_install
3754 7C6E              ;
3755 7C6E              ; System Loader install program
3756 7C6E              ;===============================================================================
3757 7C6E
3758 7C6E              loader_install PROC 
3759 7C6E
3760 7C6E                       longa on
3761 7C6E                       longi on
3762 7C6E
3763 7C6E              ;tell Tool Locator where Loader Caller is
3764 7C6E
3765 7C6E F4 00 00              pea   0000                     ;Was push System Tool indicator
3766 7C71 F4 11 00              pea   Loader_TSN               ;Was push Loader Tool number
3767 7C74 F4 01 00              pea   #^Loader_Entry           ;Loader Call Table
3768 7C77 F4 00 A6              pea   #<Loader_Entry
3769 7C7A
3770 7C7A A2 01 0A 22           _SetTSPtr 
3771 7C81
3772 7C81 6B                    rtl   
3773 7C82
3774 7C82                       ENDP 
3775 7C82
3776 7C82                       eject 
3777 7C82              ;===============================================================================
3778 7C82              ;
3779 7C82              ; gldr_data
3780 7C82              ;
3781 7C82              ;===============================================================================
3782 7C82
3783 7C82              gldr_data PROC 
3784 7C82
3785 7C82
3786 7C82              ;-------------------------------------------------------------------------------
3787 7C82              ; parameter blocks for GS/OS calls
3788 7C82              ;-------------------------------------------------------------------------------
3789 7C82
3790 7C82                       EXPORT open_parms1
3791 7C82              open_parms1                             ;Open - class 1 parameter list
3792 7C82 03 00                 DC W:3                         ;parameter count
3793 7C84                       EXPORT open_ref
3794 7C84 02 00        open_ref DS B:2                         ;reference number
3795 7C86                       EXPORT open_path
3796 7C86 2E 7D 00 00  open_path DC L:path_buf                 ;pointer to pathname
3797 7C8A 01 00                 DC W:1                         ;read access
3798 7C8C
3799 7C8C                       EXPORT close_parms1
3800 7C8C              close_parms1                            ;Close - class 1 parameter list
3801 7C8C 01 00                 DC W:1                         ;parameter count
3802 7C8E                       EXPORT close_ref
3803 7C8E 02 00        close_ref DS B:2                        ;reference number
3804 7C90
3805 7C90                       EXPORT gde_parms1
3806 7C90              gde_parms1                              ;GetDirEntry - class 1 parameter list
3807 7C90 0D 00                 DC W:13                        ;parameter count
3808 7C92                       EXPORT gde_ref
3809 7C92 02 00        gde_ref  DS B:2                         ;reference number
3810 7C94 00 00                 DS B:2                         ;flags
3811 7C96 00 00                 DC W:0                         ;base
3812 7C98                       EXPORT gde_disp
3813 7C98 02 00        gde_disp DS B:2                         ;displacement
3814 7C9A 0A 7D 00 00           DC L:filename1                 ;ptr to class 1 output string
3815 7C9E 01 00                 DS B:2                         ;entry number
3816 7CA0                       EXPORT gde_filetype
3817 7CA0 B8 00        gde_filetype DS B:2                     ;file type
3818 7CA2 06 3B 00 00           DS B:4                         ;eof
3819 7CA6 1F 00 00 00           DS B:4                         ;block count
3820 7CAA 00 36 11 5D           DS B:8                         ;create date and time
3821 7CB2 00 37 11 5D           DS B:8                         ;mod date and time
3822 7CBA E3 00                 DS B:2                         ;access
3823 7CBC                       EXPORT gde_auxtype
3824 7CBC 00 00 00 00  gde_auxtype DS B:4                      ;aux type
3825 7CC0
3826 7CC0                       EXPORT quit_parms1
3827 7CC0              quit_parms1                             ;Quit - class 1 parameter list
3828 7CC0 02 00                 DC W:2                         ;parameter count
3829 7CC2 A1 D7 E1 00           DC L:e1_start_prog1            ;ptr to system program pathname
3830 7CC6 00 00                 DC W:0                         ;don't return, don't restart
3831 7CC8
3832 7CC8                       EXPORT setpfx0_parms1
3833 7CC8              setpfx0_parms1                          ;SetPrefix 0 - class 1 parameter list
3834 7CC8 02 00                 DC W:2                         ;parameter count
3835 7CCA 00 00                 DC W:0                         ;set prefix 0/.
3836 7CCC F7 D6 E1 00           DC L:e1_volname                ;points to boot volume name
3837 7CD0
3838 7CD0
3839 7CD0              ;-------------------------------------------------------------------------------
3840 7CD0              ; general storage
3841 7CD0              ;-------------------------------------------------------------------------------
3842 7CD0
3843 7CD0                       EXPORT save_mslot
3844 7CD0 C7 00        save_mslot DS B:2                       ;boot slot #
3845 7CD2                       EXPORT temp_setup
3846 7CD2 00 00        temp_setup DS B:2                       ;1 = setup file should be shutdown
3847 7CD4                       EXPORT da_type
3848 7CD4 B8 00        da_type  DS B:2                         ;desk accessory file type (CDA vs NDA)
3849 7CD6                       EXPORT gotp8
3850 7CD6 00 00        gotp8    DC W:0                         ;1 = P8 is on boot disk (init to 0)
3851 7CD8                       EXPORT custom_boot
3852 7CD8 00 00        custom_boot DS B:2                      ;flags for custom boot
3853 7CDA                       EXPORT skip_cdas
3854 7CDA 00 00        skip_cdas DC W:0                        ;1 = max # of CDAs installed (init to 0)
3855 7CDC                       EXPORT save_filetype
3856 7CDC 00 00        save_filetype DS B:2                    ;filetype of start application
3857 7CDE                       EXPORT perm_msg_size
3858 7CDE A1 0E        perm_msg_size DS B:2                    ;size of permanent section of ERROR.MSG file
3859 7CE0                       EXPORT big_system
3860 7CE0 00 00        big_system DC W:0                       ;1 = system is > 512K (init to 0)
3861 7CE2                       EXPORT boot_hndl
3862 7CE2 18 18 E1 00  boot_hndl DS B:4                        ;handle to GLoader memory segment
3863 7CE6                       EXPORT buf_hndl
3864 7CE6 68 18 E1 00  buf_hndl DS B:4                         ;handle to buffer
3865 7CEA                       EXPORT buf_ptr
3866 7CEA 00 00 4E 00  buf_ptr  DS B:4                         ;pointer to buffer
3867 7CEE                       EXPORT save_d
3868 7CEE 00 00        save_d   DS B:2                         ;temp to save direct register
3869 7CF0                       EXPORT text_flag
3870 7CF0 00 00        text_flag DS B:2                        ;0 = don't put up msgs, $FFFF = put up msgs
3871 7CF2                       EXPORT path_len
3872 7CF2 13 00        path_len DS B:2                         ;length of partial pathname
3873 7CF4                       EXPORT iload_type
3874 7CF4 01 00        iload_type DS B:2                       ;type of initial_load to do
3875 7CF6                       EXPORT load_adr
3876 7CF6 0E 69 04 00  load_adr DS B:4                         ;address of loaded file
3877 7CFA                       EXPORT filetype
3878 7CFA BD 00        filetype DS B:2                         ;filetype returned by read_the_file
3879 7CFC                       EXPORT auxtype
3880 7CFC 00 00        auxtype  DS B:2                         ;auxtype returned by read_the_file
3881 7CFE                       EXPORT got_filename
3882 7CFE 00 00        got_filename DC W:0                     ;1 = got a filename for error msg (init to 0)
3883 7D00
3884 7D00
3885 7D00              ; The following 4 bytes are used for storing the load address of the start FST
3886 7D00
3887 7D00                       EXPORT fst_address
3888 7D00 C3 1D 02 00  fst_address DS B:4
3889 7D04
3890 7D04              ; The following table is used when loading the start FST, ERROR.MSG,
3891 7D04              ; GS.OS.DEV, and BOOT.DRIVER files
3892 7D04              ; load_file_len MUST immediately follow load_file_adr.
3893 7D04
3894 7D04                       EXPORT load_file_adr
3895 7D04 00 00 4E 00  load_file_adr DS B:4                    ;address of load file
3896 7D08                       EXPORT load_file_len
3897 7D08 ED 63        load_file_len DS B:2                    ;length of load file
3898 7D0A
3899 7D0A              ; The following 36 bytes are used when making a class 1 GetDirEntry call.
3900 7D0A              ; The first 2 bytes contain the buffer size.  The next 34 bytes are used for -
3901 7D0A              ; length (2 bytes), filename (32 bytes).
3902 7D0A
3903 7D0A                       EXPORT filename1
3904 7D0A 24 00        filename1 DC W:36                       ;size header for class 1 output string
3905 7D0C                       EXPORT filename
3906 7D0C 0C 00 43 6F  filename DS B:34                        ;must follow filename1
3907 7D2E
3908 7D2E              ; The following buffer is used to build pathnames when loading the setup files,
3909 7D2E              ; desk accessories and FSTs.  The pathnames are class 1 strings.
3910 7D2E              ; Maximum length of a pathname is 54 bytes -
3911 7D2E              ;   '*/SYSTEM/SYSTEM.SETUP/' (22 bytes), filename (32 bytes)
3912 7D2E
3913 7D2E                       EXPORT path_buf
3914 7D2E 1F 00 2A 3A  path_buf DS B:56
3915 7D66
3916 7D66              ; The following bytes are used for storing the name of the start FST in
3917 7D66              ; class 1 format with no leading or trailing separators.
3918 7D66
3919 7D66                       EXPORT startfst_name
3920 7D66 07 00 50 52  startfst_name DS B:34
3921 7D88
3922 7D88                       ENDP 
3923 7D88
3924 7D88
3925 7D88
3926 7D88              ;===============================================================================
3927 7D88              ;
3928 7D88              ; gldr_strings
3929 7D88              ;
3930 7D88              ;===============================================================================
3931 7D88
3932 7D88              gldr_strings PROC 
3933 7D88
3934 7D88                       msb   on
3935 7D88
3936 7D88              ;column indicator 1-40    1234567890123456789212345678931234567894
3937 7D88              ;                41-80    1234567895123456789612345678961234567898
3938 7D88
3939 7D88                       EXPORT gs_os_credit
3940 7D88 8D           gs_os_credit DC B:$8d
3941 7D89 D7 E5 EC E3           DC B:'Welcome to the world of GS/OS      v'
3942 7DAD B4 AE B0 B2           verNum                         ;macro defined at beginning of file
3943 7DB1 A0 A0 A0 A0           DC B:'     The Apple IIGS Operating System'
3944 7DD5 8D 8D                 DC B:$8d,$8d                   ;terminate with a <cr> and skip a line
3945 7DD7
3946 7DD7 C3 EF F0 F9           DC B:'Copyright 1983-1993 by Apple Computer, '
3947 7DFE C9 EE E3 AE           DC B:'Inc.  '
3948 7E04 B0 B6 AD CD           verDate                        ;macro defined at beginning of file
3949 7E0D A0 A0 A0 C1           DC B:'   All rights reserved.'
3950 7E24 8D 8D 00              DC B:$8d,$8d,0                 ;terminate message with a $00
3951 7E27
3952 7E27                       EXPORT pressanykey
3953 7E27 8D           pressanykey DC B:$8d                    ;carriage return
3954 7E28 AD AD BE A0           DC B:'-->  Press space bar to continue  <--'
3955 7E4D 00                    DC B:0                         ;terminate message with a $00
3956 7E4E
3957 7E4E                       msb   off
3958 7E4E
3959 7E4E                       EXPORT mem_size_err
3960 7E4E 30 52 41 4D  mem_size_err DC C:'RAM disk too large or not enough memory. Error=$'
3961 7E7F                       EXPORT alloc_err
3962 7E7F 2A 45 72 72  alloc_err DC C:'Error allocating memory for GS/OS. Error=$'
3963 7EAA                       EXPORT volname_err
3964 7EAA 25 45 72 72  volname_err DC C:'Error reading boot disk name. Error=$'
3965 7ED0                       EXPORT gsos_err
3966 7ED0 21 45 72 72  gsos_err DC C:'Error loading GS.OS file. Error=$'
3967 7EF2                       EXPORT loader_err
3968 7EF2 27 45 72 72  loader_err DC C:'Error installing System Loader. Error=$'
3969 7F1A                       EXPORT msgfile_err
3970 7F1A 25 45 72 72  msgfile_err DC C:'Error loading ERROR.MSG file. Error=$'
3971 7F40
3972 7F40                       EXPORT sysname
3973 7F40 07 2E 53 59  sysname  DC C:'.SYSTEM'
3974 7F48                       EXPORT s16name
3975 7F48 06 2E 53 59  s16name  DC C:'.SYS16'
3976 7F4F
3977 7F4F                       EXPORT toolsetup_name
3978 7F4F 0A 00        toolsetup_name DC W:10                  ;class 1 string
3979 7F51 54 4F 4F 4C           DC B:'TOOL.SETUP'
3980 7F5B
3981 7F5B                       EXPORT resmgr_name
3982 7F5B 0C 00        resmgr_name DC W:12                     ;class 1 string
3983 7F5D 52 45 53 4F           DC B:'RESOURCE.MGR'
3984 7F69
3985 7F69                       EXPORT gsos_path
3986 7F69 0C 00        gsos_path DC W:12                       ;class 1 string
3987 7F6B 53 59 53 54           DC B:'SYSTEM:GS.OS'
3988 7F77
3989 7F77                       EXPORT errmsg_path
3990 7F77 10 00        errmsg_path DC W:16                     ;class 1 string
3991 7F79 53 59 53 54           DC B:'SYSTEM:ERROR.MSG'
3992 7F89
3993 7F89                       EXPORT gsosdev_path
3994 7F89 10 00        gsosdev_path DC W:16                    ;class 1 string
3995 7F8B 53 59 53 54           DC B:'SYSTEM:GS.OS.DEV'
3996 7F9B
3997 7F9B                       EXPORT startfst_path
3998 7F9B 13 00        startfst_path  DC W:12                  ;class 1 string
3999 7F9D 53 59 53 54           DC B:'SYSTEM:FSTS:'
4000 7FA9 50 52 4F 2E           DS B:32                        ;space for start fst name
4001 7FC9
4002 7FC9                       EXPORT driver_path
4003 7FC9 1A 00        driver_path DC W:26                     ;class 1 string
4004 7FCB 53 59 53 54           DC B:'SYSTEM:DRIVERS:BOOT.DRIVER'
4005 7FE5
4006 7FE5                       EXPORT vol_path
4007 7FE5 02 00        vol_path DC W:2                         ;class 1 string
4008 7FE7 2A 3A                 DC B:'*:'
4009 7FE9
4010 7FE9                       EXPORT fst_path
4011 7FE9 0D 00        fst_path DC W:13                        ;class 1 string
4012 7FEB 2A 3A 53 59           DC B:'*:SYSTEM:FSTS'
4013 7FF8
4014 7FF8                       EXPORT setup_path
4015 7FF8 16 00        setup_path DC W:22                      ;class 1 string
4016 7FFA 2A 3A 53 59           DC B:'*:SYSTEM:SYSTEM.SETUP:'
4017 8010
4018 8010                       EXPORT toolsetup_path
4019 8010 20 00        toolsetup_path DC W:32                  ;class 1 string
4020 8012 2A 3A 53 59           DC B:'*:SYSTEM:SYSTEM.SETUP:TOOL.SETUP'
4021 8032
4022 8032                       EXPORT resmgr_path
4023 8032 22 00        resmgr_path DC W:34                     ;class 1 string
4024 8034 2A 3A 53 59           DC B:'*:SYSTEM:SYSTEM.SETUP:RESOURCE.MGR'
4025 8056
4026 8056                       EXPORT da_path
4027 8056 13 00        da_path  DC W:19                        ;class 1 string
4028 8058 2A 3A 53 59           DC B:'*:SYSTEM:DESK.ACCS:'
4029 806B
4030 806B                       EXPORT startpath
4031 806B 0E 00        startpath DC W:14                       ;class 1 string
4032 806D 2A 3A 53 59           DC B:'*:SYSTEM:START'
4033 807B
4034 807B                       ENDP 
4035 807B
4036 807B              *********************************************************************************
4037 807B              org_dummy_2 proc org gldr_obj_pad       ;pad to next code segment
4038 807B                       endp 
4039 807B              *********************************************************************************
